/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.log;

import com.coreframework.log.LogInfo;
import com.coreframework.log.LogInfoEvent;
import com.coreframework.log.LogLevel;
import com.coreframework.log.LogModuleHandler;
import com.coreframework.log.LogStandard;
import com.coreframework.log.Logger;
import com.coreframework.remoting.reflect.Rpc;
import com.coreframework.remoting.reflect.RpcException;
import com.coreframework.remoting.reflect.StubRequest;
import com.lmax.disruptor.EventHandler;
import java.util.HashMap;

public class LogInfoEventHandler
implements EventHandler<LogInfoEvent> {
    private static final HashMap<String, LogModuleHandler> LogModuleHandlerMap = new HashMap();

    public void setLogModuleHandler(String moduleName, LogModuleHandler handler) {
        LogModuleHandlerMap.put(moduleName, handler);
    }

    @Override
    public void onEvent(LogInfoEvent event, long l, boolean b) {
        try {
            LogInfo info = event.getValue();
            if (info.getLevel().equals((Object)LogLevel.ERROR)) {
                System.out.println(info.getContent() == null ? "" : info.getContent().toString());
            }
            LogModuleHandler logModuleHandler = LogModuleHandlerMap.get(info.getModuleName());
            boolean isSuccess = false;
            if (logModuleHandler != null) {
                isSuccess = logModuleHandler.handler(info);
            }
            if (!isSuccess && Logger.centerUrl != null) {
                StubRequest r = new StubRequest(Logger.centerUrl);
                r.setWithOutResultMode();
                r.setConnectTimeOutMills(1000);
                LogStandard log = (LogStandard)Rpc.stub(LogStandard.class, r);
                log.log(info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("send log error:" + RpcException.getException(e));
        }
    }
}

