/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.log;

import com.coreframework.log.FileLogOper;
import com.coreframework.log.LogInfo;
import com.coreframework.log.LogInfoEvent;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.RingBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogInfoEventProducer {
    private final RingBuffer<LogInfoEvent> ringBuffer;
    private SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");

    public LogInfoEventProducer(RingBuffer<LogInfoEvent> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    public void onData(LogInfo info) {
        try {
            long sequence = this.ringBuffer.tryNext();
            LogInfoEvent event = this.ringBuffer.getPreallocated(sequence);
            event.setValue(info);
            this.ringBuffer.publish(sequence);
        }
        catch (InsufficientCapacityException e) {
            FileLogOper.write(String.valueOf(this.df.format(new Date())) + ".log", info);
        }
    }
}

