/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.log;

import com.coreframework.log.LogBody;
import com.coreframework.log.LogHeader;
import com.coreframework.log.LogInfo;
import com.coreframework.log.LogInfoEvent;
import com.coreframework.log.LogInfoEventFactory;
import com.coreframework.log.LogInfoEventHandler;
import com.coreframework.log.LogInfoEventProducer;
import com.coreframework.log.LogLevel;
import com.coreframework.log.LogModuleHandler;
import com.coreframework.remoting.Url;
import com.coreframework.remoting.sr.ServerInvokeResult;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Logger {
    private static volatile Logger instance = null;
    public static final int BufferSize = 4096;
    protected static Url centerUrl = null;
    private boolean debugEnable = false;
    private LogInfoEventProducer producer = null;
    private LogInfoEventHandler logInfoEventHandler = null;
    private static final String DEFAULT_MODULE = "DEFAULT";
    private static final String SYS_NAME = "sysname";

    public boolean isDebugEnable() {
        return this.debugEnable;
    }

    public void setDebugEnable(boolean debugEnable) {
        this.debugEnable = debugEnable;
    }

    private Logger() {
        ExecutorService executor = Executors.newCachedThreadPool();
        LogInfoEventFactory factory = new LogInfoEventFactory();
        Disruptor<LogInfoEvent> disruptor = new Disruptor<LogInfoEvent>(factory, 4096, executor, ProducerType.SINGLE, new SleepingWaitStrategy());
        this.logInfoEventHandler = new LogInfoEventHandler();
        disruptor.handleEventsWith(this.logInfoEventHandler);
        disruptor.start();
        RingBuffer<LogInfoEvent> ringBuffer = disruptor.getRingBuffer();
        this.producer = new LogInfoEventProducer(ringBuffer);
    }

    public void setLogModuleHandler(String moduleName, LogModuleHandler handler) {
        this.logInfoEventHandler.setLogModuleHandler(moduleName, handler);
    }

    public InetAddress getLocalHost() {
        Enumeration<NetworkInterface> netInterfaces;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        InetAddress ip = null;
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            ip = ni.getInetAddresses().nextElement();
            if (!ip.isSiteLocalAddress() && !ip.isLoopbackAddress() && ip.getHostAddress().indexOf(":") == -1) break;
            ip = null;
        }
        return ip;
    }

    private String getLocalIP() {
        String ip = null;
        try {
            Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
            while (e1.hasMoreElements()) {
                NetworkInterface ni = e1.nextElement();
                if (!ni.getName().equals("eth0")) continue;
                Enumeration<InetAddress> e2 = ni.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress ia = e2.nextElement();
                    if (ia instanceof Inet6Address) continue;
                    ip = ia.getHostAddress();
                }
                break;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Logger get() {
        if (instance != null) return instance;
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (instance != null) return instance;
            instance = new Logger();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LogHeader getLogHeader() {
        return this.getLogHeader(null, null);
    }

    private LogHeader getLogHeader(String prefix, String vague) {
        LogHeader header = new LogHeader();
        try {
            String os = System.getProperties().getProperty("os.name");
            String ip = null;
            ip = os.startsWith("win") || os.startsWith("Win") ? InetAddress.getLocalHost().getHostAddress().toString() : this.getLocalIP();
            header.setIp(ip == null ? "0.0.0.0" : ip);
            StackTraceElement[] stack = new Throwable().getStackTrace();
            if (stack != null) {
                int i = 0;
                while (i < stack.length) {
                    StackTraceElement s = stack[i];
                    if (!s.getClassName().equals(Logger.class.getName())) {
                        if (prefix != null) {
                            if (s.getClassName().startsWith(prefix) && s.getClassName().indexOf(vague) > 0) {
                                header.setClassName(s.getClassName());
                                header.setLineNumber(s.getLineNumber());
                                header.setMethodName(s.getMethodName());
                                break;
                            }
                        } else {
                            header.setClassName(s.getClassName());
                            header.setLineNumber(s.getLineNumber());
                            header.setMethodName(s.getMethodName());
                            break;
                        }
                    }
                    ++i;
                }
            }
            try {
                String path = null;
                if (this.getClass().getClassLoader().getResource("") != null) {
                    path = this.getClass().getClassLoader().getResource("").getPath().replaceAll("/WEB-INF/classes/", "");
                    int index = path.lastIndexOf("/");
                    header.setAppName(path.substring(index + 1));
                } else {
                    path = this.getClass().getResource("").getPath();
                    int index = path.indexOf("/bin/");
                    path = path.substring(0, index);
                    index = path.lastIndexOf("/");
                    header.setAppName(path.substring(index + 1));
                }
                header.setPath(path);
                if (System.getProperty(SYS_NAME) != null) {
                    header.setAppName(System.getProperty(SYS_NAME, "Default"));
                }
                return header;
            }
            catch (Exception e) {
                header.setAppName("Default");
                header.setPath("\u672a\u77e5");
                return header;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return header;
        }
    }

    public void log(LogLevel level, String module, LogBody body) {
        this.log(level, module, null, body, null, null);
    }

    public void log(LogLevel level, String module, String appenderFileName, LogBody body, String prefix, String vague) {
        if (level.equals((Object)LogLevel.DEBUG)) {
            if (Logger.get().isDebugEnable()) {
                System.out.println(body.toString() == null ? "" : body.toString());
            }
            return;
        }
        LogInfo info = new LogInfo();
        info.setHeader(this.getLogHeader(prefix, vague));
        info.setLevel(level == null ? LogLevel.INFO : level);
        info.setContent(body == null ? "" : body.toString());
        info.setModuleName(module == null ? DEFAULT_MODULE : module);
        info.setAppenderFileName(appenderFileName);
        this.producer.onData(info);
    }

    public void log(ServerInvokeResult ret) {
    }

    public void error(String module, String appenderFileName, Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter w = new PrintWriter(sw);
        e.printStackTrace(w);
        this.log(LogLevel.ERROR, module, appenderFileName, LogBody.me().set("exception", sw.toString()), null, null);
    }

    public void error(Exception e) {
        this.error(null, null, e);
    }

    public void error(String module, LogBody body) {
        this.log(LogLevel.ERROR, module, body);
    }

    public void error(String module, String appenderFileName, LogBody body) {
        this.log(LogLevel.ERROR, module, appenderFileName, body, null, null);
    }

    public void error(LogBody body) {
        this.log(LogLevel.ERROR, null, body);
    }

    public void info(String module, LogBody body) {
        this.log(LogLevel.INFO, module, body);
    }

    public void info(String module, LogBody body, String prefix, String vague) {
        this.log(LogLevel.INFO, module, null, body, prefix, vague);
    }

    public void info(LogBody body) {
        this.log(LogLevel.INFO, null, body);
    }

    public void info(String module, String appenderFileName, LogBody body) {
        this.log(LogLevel.INFO, module, appenderFileName, body, null, null);
    }

    public void debug(String msg) {
        this.log(LogLevel.DEBUG, null, LogBody.me().set("debug", msg));
    }
}

