/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting;

import com.coreframework.remoting.ClientSendException;
import com.coreframework.remoting.ConnectException;
import com.coreframework.remoting.IoHandlerWrapper;
import com.coreframework.remoting.IoListener;
import com.coreframework.remoting.Url;
import com.coreframework.remoting.reflect.ClientIoListener;
import com.coreframework.remoting.reflect.Request;
import com.coreframework.remoting.reflect.ResponseHandler;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class Client {
    private IoSession session;
    private static final ConcurrentMap<String, Client> map = new ConcurrentHashMap<String, Client>();
    private Object lock = new Object();
    private Url url;
    private int connectTimeOutMills;
    private IoListener ioListener;
    private ConnectFuture cf;
    private NioSocketConnector connector;

    private Client() {
    }

    private Client(Url url, int connectTimeOutMills) {
        this.url = url;
        this.connectTimeOutMills = connectTimeOutMills;
        this.ioListener = new ClientIoListener(){};
    }

    public void addHandler(String reqId, ResponseHandler handler) {
        if (this.ioListener instanceof ClientIoListener) {
            ((ClientIoListener)this.ioListener).addHandler(reqId, handler);
        }
    }

    public IoListener getIoListener() {
        return this.ioListener;
    }

    public void setIoListener(IoListener ioListener) {
        this.ioListener = ioListener;
    }

    public static Client getInstance(Url url, int connectTimeOutMills) {
        String key = String.valueOf(url.toString()) + "." + connectTimeOutMills;
        Client rpc = (Client)map.get(key);
        if (rpc == null) {
            rpc = new Client(url, connectTimeOutMills);
            map.putIfAbsent(key, rpc);
            return (Client)map.get(key);
        }
        return rpc;
    }

    public boolean connect() throws ConnectException {
        return this.checkedSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkedSession() throws ConnectException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.connector == null || this.connector.isDisposed()) {
                    this.connector = new NioSocketConnector();
                    this.connector.setConnectTimeoutMillis(this.connectTimeOutMills);
                    this.connector.setHandler(new IoHandlerWrapper(this.ioListener));
                    this.connector.getFilterChain().addLast("codec", new ProtocolCodecFilter(new ObjectSerializationCodecFactory()));
                }
                if (this.cf == null || !this.cf.isConnected()) {
                    this.cf = this.connector.connect(new InetSocketAddress(this.url.getIp(), this.url.getPort()));
                    this.cf.awaitUninterruptibly(this.connectTimeOutMills);
                }
                if (this.session == null || !this.session.isConnected()) {
                    this.cf = this.connector.connect(new InetSocketAddress(this.url.getIp(), this.url.getPort()));
                    this.cf.awaitUninterruptibly(this.connectTimeOutMills);
                    this.session = this.cf.getSession();
                    if (this.session == null) {
                        throw new ConnectException(this.url.getIp(), this.url.getPort(), "\u8fde\u63a5\u670d\u52a1\u7aef\u5931\u8d25.session=null");
                    }
                }
                return true;
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Exception e) {
                    if (this.session != null) {
                        this.session.close(true);
                    }
                    throw new ConnectException(this.url.getIp(), this.url.getPort(), "\u8fde\u63a5\u670d\u52a1\u7aef\u5931\u8d25." + e.getMessage());
                }
            }
        }
    }

    public void send(Serializable message) throws ConnectException, ClientSendException {
        this.checkedSession();
        try {
            this.session.write(message);
        }
        catch (Exception ex) {
            throw new ClientSendException(message, ex.getMessage());
        }
    }

    public void send(Request message) throws ConnectException, ClientSendException {
        this.checkedSession();
        try {
            this.session.setAttribute("lockid", message.getReqId());
            this.session.setAttribute("methodname", message.getMethodName());
            this.session.setAttribute("interfaceClassName", message.getRemoteInterfaceClassName());
            this.session.write(message);
        }
        catch (Exception ex) {
            throw new ClientSendException(message, ex.getMessage());
        }
    }
}

