/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting;

import com.coreframework.ioc.Ioc;
import com.coreframework.remoting.IoHandlerWrapper;
import com.coreframework.remoting.IoListener;
import com.coreframework.remoting.PortBindException;
import com.coreframework.remoting.Url;
import com.coreframework.remoting.Version;
import com.coreframework.remoting.reflect.AbstractBean;
import com.coreframework.remoting.reflect.Request;
import com.coreframework.remoting.reflect.ServerIoListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class Server {
    private static Server instance;
    private static Object _lock;
    public static int RECORD_RESPONSE_SECONDS;
    private static final int DEFAULT_SIZE;
    private int port;
    private IoListener listener;
    private IoAcceptor acceptor;

    static {
        _lock = new Object();
        RECORD_RESPONSE_SECONDS = 3000;
        DEFAULT_SIZE = Runtime.getRuntime().availableProcessors() + 1;
    }

    private Server() {
    }

    public void setDebug(boolean debug) {
        if (this.listener != null) {
            this.listener.setDebug(debug);
        }
    }

    public void addInstance(Class<?> c, Object obj) {
        ServerIoListener.addInstance(c, obj);
    }

    @Deprecated
    public void setHandlerTimeOut(Object o) {
    }

    private Server(int port) {
        this.port = port;
        ServerIoListener s = new ServerIoListener(new AbstractBean(){

            @Override
            public Object get(Request req, Url url, boolean isInterface) {
                try {
                    if (isInterface) {
                        return Ioc.get(req.getRemoteInterfaceClassName());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        }){};
        this.listener = s;
        this.setDebug(true);
    }

    private Server(int port, AbstractBean bean) {
        this.port = port;
        this.listener = new ServerIoListener(bean){};
        this.setDebug(true);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public IoListener getListener() {
        return this.listener;
    }

    public void setListener(IoListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Server getInstance(int port) {
        if (instance == null) {
            Object object = _lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new Server(port);
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Server getInstance(int port, AbstractBean bean) {
        if (instance == null) {
            Object object = _lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new Server(port, bean);
                }
            }
        }
        return instance;
    }

    public void start() throws PortBindException {
        Version.print();
        this.acceptor = new NioSocketAcceptor(DEFAULT_SIZE);
        this.acceptor.getFilterChain().addLast("codec", new ProtocolCodecFilter(new ObjectSerializationCodecFactory()));
        this.acceptor.getFilterChain().addLast("threadPool", new ExecutorFilter(Executors.newCachedThreadPool()));
        this.acceptor.setHandler(new IoHandlerWrapper(this.listener));
        this.acceptor.setDefaultLocalAddress(new InetSocketAddress(this.port));
        try {
            this.acceptor.bind();
        }
        catch (IOException e) {
            throw new PortBindException(this.port, e.getMessage());
        }
    }

    public void start(int coreSize, int maxSize) throws PortBindException {
        Version.print();
        this.acceptor = new NioSocketAcceptor(DEFAULT_SIZE);
        this.acceptor.getFilterChain().addLast("codec", new ProtocolCodecFilter(new ObjectSerializationCodecFactory()));
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSize, maxSize, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(coreSize), new ThreadPoolExecutor.CallerRunsPolicy());
        this.acceptor.getFilterChain().addLast("threadPool", new ExecutorFilter(executor));
        this.acceptor.setHandler(new IoHandlerWrapper(this.listener));
        this.acceptor.setDefaultLocalAddress(new InetSocketAddress(this.port));
        try {
            this.acceptor.bind();
        }
        catch (IOException e) {
            throw new PortBindException(this.port, e.getMessage());
        }
    }

    public void dispose() {
        this.acceptor.dispose(true);
    }
}

