/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting;

import com.coreframework.log.LogBody;
import com.coreframework.log.Logger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolFactory {
    public static final ThreadPoolExecutor pushDealPool = ThreadPoolFactory.create("pushdeal", 10, 150, 5, new SynchronousQueue<Runnable>());

    public static ThreadPoolExecutor create(String name, int corePoolSize, int maximumPoolSize, int keepAliveTime, BlockingQueue<Runnable> workQueue) {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, workQueue);
        pool.setThreadFactory(new DefaultThreadFactory(name));
        pool.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                Logger.get().error("ThreadPool.Rejected", new LogBody().set("PoolSize", executor.getPoolSize()).set("ActiveCount", executor.getActiveCount()).set("TaskCount", executor.getTaskCount()).set("CompletedTaskCount", executor.getCompletedTaskCount()).set("QueueSize", executor.getQueue().size()).set("CorePoolSize", executor.getCorePoolSize()).set("LargestPoolSize", executor.getLargestPoolSize()).set("MaximumPoolSize", executor.getMaximumPoolSize()));
            }
        });
        return pool;
    }

    public static class DefaultThreadFactory
    implements ThreadFactory {
        final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        public DefaultThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "A-" + name + "-" + this.poolNumber.getAndIncrement();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, String.valueOf(this.namePrefix) + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

