/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting.reflect;

import com.coreframework.remoting.Url;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class AppUtil {
    public static String getPath() {
        String appPath = AppUtil.class.getClassLoader().getResource("").getPath().replaceAll("/WEB-INF/classes/", "");
        return appPath.substring(1);
    }

    public static boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("windows") > -1) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    public static Url getUrl(InetSocketAddress address) {
        InetAddress addr = address.getAddress();
        byte[] ipAddr = addr.getAddress();
        String ipAddrStr = "";
        int i = 0;
        while (i < ipAddr.length) {
            if (i > 0) {
                ipAddrStr = String.valueOf(ipAddrStr) + ".";
            }
            ipAddrStr = String.valueOf(ipAddrStr) + (ipAddr[i] & 0xFF);
            ++i;
        }
        return new Url(ipAddrStr, address.getPort());
    }

    public static String getLocalIP() {
        try {
            String ip = "";
            if (AppUtil.isWindowsOS()) {
                InetAddress addr = InetAddress.getLocalHost();
                ip = addr.getHostAddress().toString();
            } else {
                Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
                while (e1.hasMoreElements()) {
                    NetworkInterface ni = e1.nextElement();
                    if (!ni.getName().equals("eth0")) continue;
                    Enumeration<InetAddress> e2 = ni.getInetAddresses();
                    while (e2.hasMoreElements()) {
                        InetAddress ia = e2.nextElement();
                        if (ia instanceof Inet6Address) continue;
                        ip = ia.getHostAddress();
                    }
                    break block2;
                }
            }
            return ip;
        }
        catch (Exception ex) {
            return "0.0.0.0";
        }
    }
}

