/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting.reflect;

import com.coreframework.log.FileLogOper;
import com.coreframework.log.LogBody;
import com.coreframework.log.Logger;
import com.coreframework.remoting.IoListener;
import com.coreframework.remoting.IoSessionWrapper;
import com.coreframework.remoting.reflect.LockMap;
import com.coreframework.remoting.reflect.Response;
import com.coreframework.remoting.reflect.ResponseHandler;
import com.coreframework.remoting.reflect.ResultLock;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ClientIoListener
implements IoListener {
    private static final ConcurrentHashMap<String, ResponseHandler> handlerMap = new ConcurrentHashMap();

    @Override
    public void setDebug(boolean debug) {
    }

    public void addHandler(String reqId, ResponseHandler handler) {
        if (handler != null) {
            handlerMap.put(reqId, handler);
        }
    }

    @Override
    public void onConnect(IoSessionWrapper session) {
    }

    @Override
    public void onDisConnect(IoSessionWrapper session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onException(IoSessionWrapper session, Throwable t) {
        System.out.println("\u5ba2\u6237\u7aef\u5f02\u5e38" + t.getMessage());
        Logger.get().error("rpc.client.error", LogBody.me().set(t));
        if (session.getAttribute("lockid") != null) {
            String reqId = (String)session.getAttribute("lockid");
            ResultLock lock = LockMap.pick(reqId);
            Response resp = new Response(reqId, "");
            resp.setErrorMsg(t.getMessage());
            resp.setStatus((byte)-1);
            if (lock != null) {
                ResultLock resultLock = lock;
                synchronized (resultLock) {
                    lock.notify();
                    lock.setResult(resp);
                }
            }
        }
    }

    public boolean write(String path, String content, boolean hasAppend) {
        try {
            File writefile = new File(path);
            if (!writefile.exists()) {
                writefile.createNewFile();
                writefile = new File(path);
            }
            FileWriter filewriter = new FileWriter(writefile, hasAppend);
            filewriter.write(content);
            filewriter.flush();
            filewriter.close();
        }
        catch (Exception d) {
            System.out.println(d.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceived(Serializable obj, IoSessionWrapper session) {
        Response resp = (Response)obj;
        ResultLock lock = LockMap.pick(resp.getReqID());
        if (lock != null) {
            ResultLock resultLock = lock;
            synchronized (resultLock) {
                lock.notify();
                lock.setResult(resp);
            }
        }
        if (handlerMap.get(resp.getReqID()) != null) {
            handlerMap.get(resp.getReqID()).onReceived(resp);
            handlerMap.remove(resp.getReqID());
        }
        try {
            FileLogOper.write("rpc_timeout.log", resp.getReqID());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

