/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting.reflect;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class NetworkUtil {
    public static List<String> getLocalIPList() {
        ArrayList<String> ipList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
            while (e1.hasMoreElements()) {
                NetworkInterface ni = e1.nextElement();
                Enumeration<InetAddress> e2 = ni.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress ia = e2.nextElement();
                    if (ia instanceof Inet6Address || ia.getHostAddress().equals("127.0.0.1")) continue;
                    System.out.println(ia.getHostAddress());
                    ipList.add(ia.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return ipList;
    }

    public static String getLocalIP() {
        String ip = null;
        try {
            Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
            while (e1.hasMoreElements()) {
                NetworkInterface ni = e1.nextElement();
                if (!ni.getName().equals("eth0") || ni.isVirtual()) continue;
                Enumeration<InetAddress> e2 = ni.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress ia = e2.nextElement();
                    if (ia instanceof Inet6Address) continue;
                    ip = ia.getHostAddress();
                }
                break;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (ip == null) {
            try {
                ip = InetAddress.getLocalHost().getHostAddress().toString();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            if (ip == null) {
                return "0.0.0.0";
            }
        }
        return ip;
    }
}

