/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting.reflect;

import com.coreframework.remoting.reflect.PushListener;
import com.coreframework.remoting.reflect.PushListenerRunnable;
import com.coreframework.remoting.reflect.Request;
import com.coreframework.remoting.reflect.Response;
import com.coreframework.remoting.reflect.RpcException;
import com.coreframework.remoting.standard.DateOper;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;

public class PushCallable
implements Callable<Integer> {
    private Request req;
    private PushListener ls;
    private String name;

    public PushCallable(Request req, PushListener ls, String name) {
        this.req = req;
        this.ls = ls;
        this.name = name;
    }

    @Override
    public Integer call() throws Exception {
        try {
            Response ret = new Response(this.req.getReqId(), this.req.getReqVersion());
            ret.setStatus((byte)1);
            Class<?> c = null;
            try {
                c = Class.forName(this.req.getRemoteInterfaceClassName());
            }
            catch (ClassNotFoundException e) {
                ret.setStatus((byte)-1);
                ret.setErrorMsg(e.getMessage());
                this.ls.sendResponse(ret);
                return 0;
            }
            Object object = PushListenerRunnable.map.get(c.getName());
            if (object == null) {
                ret.setStatus((byte)-1);
                ret.setErrorMsg("\u672a\u627e\u5230" + this.req.getRemoteInterfaceClassName() + "\u5b9e\u73b0\u7c7b");
                this.ls.sendResponse(ret);
                return 0;
            }
            try {
                long start2 = System.currentTimeMillis();
                Method method = c.getMethod(this.req.getMethodName(), this.req.getParamTypes());
                Object result = method.invoke(object, this.req.getArgs());
                long invoke_mills = System.currentTimeMillis() - start2;
                ret.setConsumeMills(invoke_mills);
                ret.setResult(result);
            }
            catch (Exception e) {
                ret.setStatus((byte)-1);
                ret.setErrorMsg(e.getMessage());
            }
            System.out.println(String.valueOf(DateOper.getNow("HH:mm:ss")) + " " + "\u8fd4\u56de\u5904\u7406\u7ed3\u679c:" + ret);
            this.ls.sendResponse(ret);
            System.out.println(String.valueOf(DateOper.getNow("HH:mm:ss")) + " " + "\u8fd4\u56de\u5904\u7406\u7ed3\u679c\u5b8c\u6210");
        }
        catch (Exception e) {
            System.out.println(RpcException.getExceptionInfo(e));
        }
        return 1;
    }
}

