/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting.reflect;

import com.coreframework.remoting.ThreadPoolFactory;
import com.coreframework.remoting.Url;
import com.coreframework.remoting.reflect.PushCallable;
import com.coreframework.remoting.reflect.PushListener;
import com.coreframework.remoting.reflect.Request;
import com.coreframework.remoting.reflect.Rpc;
import com.coreframework.remoting.reflect.RpcException;
import com.coreframework.remoting.standard.DateOper;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;

public class PushListenerRunnable
implements Runnable {
    protected static final ConcurrentHashMap<String, Object> map = new ConcurrentHashMap();
    private Url pushUrl;
    private long delay;
    private String name;

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public PushListenerRunnable(String name, Url pushUrl) {
        this.pushUrl = pushUrl;
        this.delay = 50L;
        this.name = name;
    }

    public PushListenerRunnable(Url pushUrl) {
        this.pushUrl = pushUrl;
        this.delay = 50L;
    }

    public void addInstance(Class<?> c, Object instance) {
        map.putIfAbsent(c.getName(), instance);
    }

    @Override
    public void run() {
        while (true) {
            try {
                PushListener ls = Rpc.get(PushListener.class, this.pushUrl);
                Request req = ls.getRequest(this.name);
                if (req != null) {
                    System.out.println(String.valueOf(DateOper.getNow("HH:mm:ss")) + " " + this.name + ":\u6536\u5230\u8bf7\u6c42" + req);
                    PushCallable sr = new PushCallable(req, ls, this.name);
                    FutureTask<Integer> futureTask = new FutureTask<Integer>(sr);
                    ThreadPoolFactory.pushDealPool.execute(futureTask);
                }
            }
            catch (Exception e) {
                System.out.println(RpcException.getExceptionInfo(e));
            }
            try {
                Thread.sleep(this.delay);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

