/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting.reflect;

import com.coreframework.log.LogBody;
import com.coreframework.log.LogStandard;
import com.coreframework.log.Logger;
import com.coreframework.remoting.Client;
import com.coreframework.remoting.RemoteInvokeException;
import com.coreframework.remoting.reflect.Attribute;
import com.coreframework.remoting.reflect.LockMap;
import com.coreframework.remoting.reflect.PushManager;
import com.coreframework.remoting.reflect.Request;
import com.coreframework.remoting.reflect.Response;
import com.coreframework.remoting.reflect.ResultLock;
import com.coreframework.remoting.reflect.RpcRequest;
import com.coreframework.remoting.reflect.StubPushRequest;
import com.coreframework.remoting.reflect.TimeOutException;
import com.coreframework.remoting.standard.Standard;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;

public class RemoteImplInvocationHandler
implements InvocationHandler {
    private static final List<String> methodList = new ArrayList<String>();
    private RpcRequest req;
    private String localInterface;

    static {
        methodList.add("equals");
        methodList.add("getClass");
        methodList.add("hashCode");
        methodList.add("notify");
        methodList.add("notifyAll");
        methodList.add("toString");
        methodList.add("wait");
    }

    public RemoteImplInvocationHandler() {
    }

    public RemoteImplInvocationHandler(String localInterface, RpcRequest req) {
        this.req = req;
        this.localInterface = localInterface;
    }

    private static Object getDefaultValue(Class<?> c) {
        if (c.isPrimitive()) {
            if (c == Integer.TYPE) {
                return Integer.MIN_VALUE;
            }
            if (c == Double.TYPE) {
                return Double.MIN_VALUE;
            }
            if (c == Float.TYPE) {
                return Float.valueOf(Float.MIN_VALUE);
            }
            if (c == Float.TYPE) {
                return Float.valueOf(Float.MIN_VALUE);
            }
            if (c == Boolean.TYPE) {
                return true;
            }
            if (c == Byte.TYPE) {
                return (byte)-128;
            }
            if (c == Character.TYPE) {
                return Character.valueOf('0');
            }
            return null;
        }
        return null;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.invokeCore(this.localInterface, method.getParameterTypes(), method.getReturnType(), method.getName(), args, this.req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeCore(String localInterface, Class<?>[] paramType, Class<?> returnType, String methodName, Object[] args, RpcRequest req) throws Exception {
        Object object;
        ResultLock r;
        int status;
        String exception;
        Response resp;
        Request request;
        long invoke_mills;
        boolean isSuccess;
        block27: {
            StubPushRequest subPushReq;
            long seconds = System.currentTimeMillis() / 1000L;
            isSuccess = false;
            invoke_mills = 0L;
            request = null;
            resp = null;
            exception = null;
            status = 1;
            if (req.getRpcReqId() != null) {
                request = new Request(req.getRpcReqId());
            } else {
                request = new Request();
                request.setReqId();
            }
            request.setRemoteInterfaceClassName(req.getRemoteInterface());
            request.setLocalInterfaceClassName(localInterface);
            request.setReqVersion(req.getReqVersion());
            request.setSeconds(seconds);
            request.setMethodName(methodName);
            request.setParamTypes(paramType);
            request.setArgs(args);
            request.setReceiveResult(req.isReceiveResult());
            request.setAttribute(new Attribute[]{new Attribute("sysname", System.getProperty("sysname", "client-default"))});
            if (req.getUrl() == null && !req.isPushMode()) {
                throw new RemoteInvokeException("\u76ee\u6807URL\u4e3a\u7a7a");
            }
            r = new ResultLock(request.getReqId());
            LockMap.store(r.getId(), r);
            if (req.getClientInvokeListener() != null) {
                req.getClientInvokeListener().onInvokeBefore(request);
            }
            if (!req.isPushMode()) {
                Client client = Client.getInstance(req.getUrl(), req.getConnectTimeOutMills());
                client.addHandler(request.getReqId(), req.getHandler());
                client.send(request);
            } else if (req instanceof StubPushRequest) {
                subPushReq = (StubPushRequest)req;
                PushManager.offer(subPushReq.getName(), request);
            } else {
                Logger.get().error("rpc.request.push", LogBody.me().set("isPushMode", req.isPushMode()).set("RemoteInterface", req.getRemoteInterface()).set("url", req.getUrl()).set("SendTimeOutMills", req.getSendTimeOutMills()).set("reqclass", req.getClass()));
                subPushReq = (StubPushRequest)req;
                PushManager.offer(subPushReq.getName(), request);
            }
            if (req.isWaitResponse() && !returnType.equals(Void.TYPE)) break block27;
            invoke_mills = -1L;
            Object object2 = RemoteImplInvocationHandler.getDefaultValue(returnType);
            LockMap.remove(request.getReqId());
            if (req.getClientInvokeListener() != null) {
                req.getClientInvokeListener().onInvokeFinish(request, resp);
            }
            if (!(request.getRemoteInterfaceClassName().equals(LogStandard.class.getName()) || request.getRemoteInterfaceClassName().equals(Standard.class.getName()) || isSuccess)) {
                Logger.get().info("rpc.request.error", LogBody.me().set("req", request).set("mills", invoke_mills).set("resp", resp).set("url", req.getUrl()).set("status", status).set("exception", exception));
            }
            return object2;
        }
        try {
            int sendTimeOutMills = req.getSendTimeOutMills(methodName);
            ResultLock resultLock = r;
            synchronized (resultLock) {
                r.wait(sendTimeOutMills);
            }
            resp = (Response)r.getResult();
            if (resp == null) {
                throw new TimeOutException("\u8bf7\u6c42\u5728" + sendTimeOutMills + "\u6beb\u79d2\u5185\u672a\u54cd\u5e94," + request.getMethodName(), request, sendTimeOutMills);
            }
            if (resp.getStatus() != 1) {
                throw new RemoteInvokeException(resp.getErrorMsg());
            }
            isSuccess = true;
            invoke_mills = resp.getConsumeMills();
            object = resp.getResult();
        }
        catch (Exception ex) {
            try {
                status = -1;
                if (ex instanceof TimeOutException) {
                    status = -2;
                }
                if (ex instanceof UndeclaredThrowableException) {
                    UndeclaredThrowableException targetEx = (UndeclaredThrowableException)ex;
                    Throwable t = targetEx.getUndeclaredThrowable();
                    exception = t.getMessage();
                } else {
                    exception = ex.getMessage();
                }
                throw ex;
            }
            catch (Throwable throwable) {
                LockMap.remove(request.getReqId());
                if (req.getClientInvokeListener() != null) {
                    req.getClientInvokeListener().onInvokeFinish(request, resp);
                }
                if (!(request.getRemoteInterfaceClassName().equals(LogStandard.class.getName()) || request.getRemoteInterfaceClassName().equals(Standard.class.getName()) || isSuccess)) {
                    Logger.get().info("rpc.request.error", LogBody.me().set("req", request).set("mills", invoke_mills).set("resp", resp).set("url", req.getUrl()).set("status", status).set("exception", exception));
                }
                throw throwable;
            }
        }
        LockMap.remove(request.getReqId());
        if (req.getClientInvokeListener() != null) {
            req.getClientInvokeListener().onInvokeFinish(request, resp);
        }
        if (!(request.getRemoteInterfaceClassName().equals(LogStandard.class.getName()) || request.getRemoteInterfaceClassName().equals(Standard.class.getName()) || isSuccess)) {
            Logger.get().info("rpc.request.error", LogBody.me().set("req", request).set("mills", invoke_mills).set("resp", resp).set("url", req.getUrl()).set("status", status).set("exception", exception));
        }
        return object;
    }
}

