/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting.reflect;

import com.coreframework.json.JSONObject;
import com.coreframework.remoting.reflect.Attribute;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class Request
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicLong REQUEST_ID = new AtomicLong(0L);
    private String reqId;
    private String reqVersion;
    private Class<?>[] paramTypes;
    private Object[] args;
    private String methodName;
    private String remoteInterfaceClassName;
    private String localInterfaceClassName;
    private Attribute[] attribute;
    private long seconds;
    private boolean receiveResult;

    public String getReqId() {
        return this.reqId;
    }

    public void setReqId() {
        this.reqId = Request.newId();
    }

    public String getReqVersion() {
        return this.reqVersion;
    }

    public void setReqVersion(String reqVersion) {
        this.reqVersion = reqVersion;
    }

    public Request() {
    }

    public Request(String reqId) {
        this.reqId = reqId;
    }

    private static String newId() {
        return String.valueOf(REQUEST_ID.getAndIncrement()) + UUID.randomUUID().toString();
    }

    public Class<?>[] getParamTypes() {
        return this.paramTypes;
    }

    public void setParamTypes(Class<?>[] paramTypes) {
        this.paramTypes = paramTypes;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getRemoteInterfaceClassName() {
        return this.remoteInterfaceClassName;
    }

    public void setRemoteInterfaceClassName(String remoteInterfaceClassName) {
        this.remoteInterfaceClassName = remoteInterfaceClassName;
    }

    public String getLocalInterfaceClassName() {
        return this.localInterfaceClassName;
    }

    public void setLocalInterfaceClassName(String localInterfaceClassName) {
        this.localInterfaceClassName = localInterfaceClassName;
    }

    public Attribute[] getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Attribute[] attribute) {
        this.attribute = attribute;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public void setSeconds(long seconds) {
        this.seconds = seconds;
    }

    public boolean isReceiveResult() {
        return this.receiveResult;
    }

    public void setReceiveResult(boolean receiveResult) {
        this.receiveResult = receiveResult;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Request) {
            Request tmp = (Request)obj;
            return tmp.getReqId() == this.getReqId();
        }
        return false;
    }

    public String toString() {
        try {
            JSONObject json = new JSONObject();
            json.put("reqId", this.reqId);
            json.put("remoteInterfaceClassName", this.remoteInterfaceClassName);
            json.put("methodName", this.methodName);
            json.put("receiveResult", this.receiveResult);
            if (this.getArgs() != null) {
                StringBuffer sb = new StringBuffer();
                Object[] objectArray = this.getArgs();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object != null) {
                        if (object.toString().length() > 1000) {
                            sb.append(object.toString().substring(0, 1000)).append("...|");
                        } else {
                            sb.append(object).append("|");
                        }
                    } else {
                        sb.append("null").append("|");
                    }
                    ++n2;
                }
                json.put("args", sb.toString());
            }
            return json.toString();
        }
        catch (Exception e) {
            return "{exception:" + e.getMessage() + "}";
        }
    }
}

