/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting.reflect;

import com.coreframework.remoting.PortBindException;
import com.coreframework.remoting.Server;
import com.coreframework.remoting.Url;
import com.coreframework.remoting.reflect.AbstractBean;
import com.coreframework.remoting.reflect.AppUtil;
import com.coreframework.remoting.reflect.Attribute;
import com.coreframework.remoting.reflect.CenterServerLookUp;
import com.coreframework.remoting.reflect.ClientInvokeListener;
import com.coreframework.remoting.reflect.InvokeRequest;
import com.coreframework.remoting.reflect.RemoteImplInvocationHandler;
import com.coreframework.remoting.reflect.Request;
import com.coreframework.remoting.reflect.ResponseHandler;
import com.coreframework.remoting.reflect.RpcRequest;
import com.coreframework.remoting.reflect.StubPushRequest;
import com.coreframework.remoting.reflect.StubRequest;
import com.coreframework.remoting.standard.CenterStandard;
import com.coreframework.remoting.standard.InitData;
import com.coreframework.remoting.standard.ServiceLocalCache;
import com.coreframework.remoting.standard.ServiceProvider;
import com.coreframework.remoting.standard.Standard;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;

public class Rpc {
    protected static final ConcurrentHashMap<RpcRequest, Object> map = new ConcurrentHashMap();
    protected static final RemoteImplInvocationHandler r = new RemoteImplInvocationHandler();

    public static <T> T get(Class<T> c, Url url, int sendTimeOutMills) {
        RpcRequest r = new StubRequest(url).setSendTimeOutMills(sendTimeOutMills);
        return Rpc.stub(c, r);
    }

    public static <T> T get(Class<T> c, Url url, int sendTimeOutMills, ResponseHandler handler) {
        RpcRequest r = new StubRequest(url).setSendTimeOutMills(sendTimeOutMills);
        r.setSyncMode(handler);
        return Rpc.stub(c, r);
    }

    public static <T> T get(Class<T> c, Url url, ResponseHandler handler) {
        StubRequest r = new StubRequest(url);
        r.setSyncMode(handler);
        return Rpc.stub(c, r);
    }

    public static <T> T get(Class<T> c, Url url) {
        return Rpc.stub(c, new StubRequest(url));
    }

    public static InitData getCenterInitData(CenterServerLookUp sl, int sendTimeOutMills) {
        final String path = AppUtil.getPath();
        StubRequest r = new StubRequest(sl.lookUp());
        r.setSendTimeOutMills(sendTimeOutMills);
        r.setWaitResponse(true);
        r.setReceiveResult(true);
        r.setClientInvokeListener(new ClientInvokeListener(){

            @Override
            public void onInvokeBefore(Request req) {
                req.setAttribute(new Attribute[]{new Attribute("path", path)});
            }
        });
        CenterStandard cs = (CenterStandard)Rpc.stub(CenterStandard.class, r);
        InitData data = cs.getInitData(AppUtil.getLocalIP(), path);
        if (data == null) {
            return null;
        }
        ServiceProvider[] array = data.getProvider();
        if (array != null && array.length > 0) {
            ServiceProvider[] serviceProviderArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceProvider serviceProvider = serviceProviderArray[n2];
                ServiceLocalCache.store(serviceProvider.getServiceName(), serviceProvider);
                ++n2;
            }
        }
        ServiceLocalCache.setServicePort(data.getServicePort());
        return data;
    }

    public static InitData getCenterInitData(final Url url, int sendTimeOutMills) {
        return Rpc.getCenterInitData(new CenterServerLookUp(){

            @Override
            public Url lookUp() {
                return url;
            }
        }, sendTimeOutMills);
    }

    public static Standard getStandard(Url url, int sendTimeOutMills) {
        return (Standard)Rpc.stub(Standard.class, new StubRequest(url).setSendTimeOutMills(sendTimeOutMills));
    }

    public static Standard getStandard(Url url, RpcRequest req) {
        return (Standard)Rpc.stub(Standard.class, req);
    }

    public static Object invoke(InvokeRequest req) throws Exception {
        return r.invokeCore(req.getRemoteInterface(), req.getParamType(), req.getReturnType(), req.getMethodName(), req.getArgs(), req);
    }

    public static <T> T stub(Class<?> c, RpcRequest req) {
        Object obj;
        if (req.getRemoteInterface() == null) {
            req.setRemoteInterface(c.getName());
        }
        if ((obj = map.get(req)) != null) {
            return (T)obj;
        }
        RemoteImplInvocationHandler handler = new RemoteImplInvocationHandler(c.getName(), req);
        obj = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{c}, (InvocationHandler)handler);
        if (req instanceof StubPushRequest) {
            map.put((StubPushRequest)req, obj);
        } else {
            map.put((StubRequest)req, obj);
        }
        return (T)map.get(req);
    }

    public static int serverStart(Url centerUrl) throws PortBindException {
        InitData initData = Rpc.getCenterInitData(centerUrl, 3000);
        int port = initData.getServicePort();
        Server.getInstance(port).start();
        return port;
    }

    public static int serverStart(Url centerUrl, AbstractBean bean) throws PortBindException {
        InitData initData = Rpc.getCenterInitData(centerUrl, 3000);
        int port = initData.getServicePort();
        Server.getInstance(port, bean).start();
        return port;
    }
}

