/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting.reflect;

import com.coreframework.remoting.Url;
import com.coreframework.remoting.reflect.ClientInvokeListener;
import com.coreframework.remoting.reflect.ResponseHandler;
import com.coreframework.remoting.reflect.StubRequest;
import java.util.HashMap;
import java.util.Map;

public class RpcRequest {
    private String rpcReqId;
    private boolean receiveResult;
    private boolean pushMode = false;
    private boolean isWaitResponse = true;
    private int connectTimeOutMills = 5000;
    private int sendTimeOutMills = 15000;
    private Map<String, Integer> sendTimeOutMillsMap;
    private String remoteInterface;
    private String reqVersion;
    private Url url;
    private ResponseHandler handler;
    private ClientInvokeListener clientInvokeListener;

    public String getRpcReqId() {
        return this.rpcReqId;
    }

    public void setRpcReqId(String rpcReqId) {
        this.rpcReqId = rpcReqId;
    }

    public RpcRequest(Url url) {
        this.url = url;
        this.setSyncMode();
    }

    public RpcRequest() {
    }

    public void setAsyncMode(ResponseHandler handler) {
        this.setWaitResponse(false);
        this.setReceiveResult(true);
        this.handler = handler;
    }

    public void setWithOutResultMode() {
        this.setWaitResponse(false);
        this.setReceiveResult(false);
    }

    public void setSyncMode(ResponseHandler handler) {
        this.setWaitResponse(true);
        this.setReceiveResult(true);
        this.handler = handler;
    }

    public void setSyncMode() {
        this.setWaitResponse(true);
        this.setReceiveResult(true);
    }

    public boolean isPushMode() {
        return this.pushMode;
    }

    public void setPushMode() {
        this.pushMode = true;
        this.setReceiveResult(true);
    }

    public boolean isReceiveResult() {
        return this.receiveResult;
    }

    public void setReceiveResult(boolean receiveResult) {
        this.receiveResult = receiveResult;
    }

    public boolean isWaitResponse() {
        return this.isWaitResponse;
    }

    public void setWaitResponse(boolean isWaitResponse) {
        this.isWaitResponse = isWaitResponse;
    }

    public int getConnectTimeOutMills() {
        return this.connectTimeOutMills;
    }

    public void setConnectTimeOutMills(int connectTimeOutMills) {
        this.connectTimeOutMills = connectTimeOutMills;
    }

    public int getSendTimeOutMills() {
        return this.sendTimeOutMills;
    }

    public RpcRequest setSendTimeOutMills(int sendTimeOutMills) {
        this.sendTimeOutMills = sendTimeOutMills;
        return this;
    }

    public int getSendTimeOutMills(String methodName) {
        if (this.sendTimeOutMillsMap == null) {
            return this.sendTimeOutMills;
        }
        Integer i = this.sendTimeOutMillsMap.get(methodName.toLowerCase());
        if (i == null) {
            return this.sendTimeOutMills;
        }
        return i;
    }

    public void addSendTimeOutMills(String methodName, int mills) {
        if (this.sendTimeOutMillsMap == null) {
            this.sendTimeOutMillsMap = new HashMap<String, Integer>();
        }
        this.sendTimeOutMillsMap.put(methodName.toLowerCase(), mills);
    }

    public String getRemoteInterface() {
        return this.remoteInterface;
    }

    public void setRemoteInterface(String remoteInterface) {
        this.remoteInterface = remoteInterface;
    }

    public String getReqVersion() {
        return this.reqVersion;
    }

    public void setReqVersion(String reqVersion) {
        this.reqVersion = reqVersion;
    }

    public Url getUrl() {
        return this.url;
    }

    public void setUrl(Url url) {
        this.url = url;
    }

    public ClientInvokeListener getClientInvokeListener() {
        return this.clientInvokeListener;
    }

    public void setClientInvokeListener(ClientInvokeListener clientInvokeListener) {
        this.clientInvokeListener = clientInvokeListener;
    }

    public ResponseHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ResponseHandler handler) {
        this.handler = handler;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StubRequest) {
            StubRequest tmp = (StubRequest)obj;
            if (this.pushMode) {
                return tmp.getRemoteInterface().equals(this.getRemoteInterface()) && this.isWaitResponse() == tmp.isWaitResponse() && this.isReceiveResult() == tmp.isReceiveResult() && this.getSendTimeOutMills() == tmp.getSendTimeOutMills() && this.getConnectTimeOutMills() == tmp.getConnectTimeOutMills();
            }
            return tmp.getRemoteInterface().equals(this.getRemoteInterface()) && tmp.getUrl().equals(this.getUrl()) && this.isWaitResponse() == tmp.isWaitResponse() && this.isReceiveResult() == tmp.isReceiveResult() && this.getSendTimeOutMills() == tmp.getSendTimeOutMills() && this.getConnectTimeOutMills() == tmp.getConnectTimeOutMills();
        }
        return false;
    }

    public int hashCode() {
        return this.remoteInterface.hashCode();
    }
}

