/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting.reflect;

import com.coreframework.log.LogBody;
import com.coreframework.log.LogStandard;
import com.coreframework.log.Logger;
import com.coreframework.remoting.IoListener;
import com.coreframework.remoting.IoSessionWrapper;
import com.coreframework.remoting.MethodAccessManager;
import com.coreframework.remoting.Server;
import com.coreframework.remoting.reflect.AbstractBean;
import com.coreframework.remoting.reflect.AppUtil;
import com.coreframework.remoting.reflect.NetworkUtil;
import com.coreframework.remoting.reflect.PushListener;
import com.coreframework.remoting.reflect.Request;
import com.coreframework.remoting.reflect.Response;
import com.coreframework.remoting.sr.ServerRunner;
import com.coreframework.remoting.standard.Standard;
import com.coreframework.remoting.standard.StandardImpl;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ServerIoListener
implements IoListener {
    private static final Standard standardImpl = new StandardImpl();
    protected static final ConcurrentHashMap<String, Object> map = new ConcurrentHashMap();
    private boolean debug;
    public static String localIP = null;
    private AbstractBean bean;

    static {
        try {
            localIP = NetworkUtil.getLocalIP();
        }
        catch (Exception e) {
            localIP = "0.0.0.0";
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public static void addInstance(Class<?> c, Object obj) {
        map.putIfAbsent(c.getName(), obj);
    }

    public ServerIoListener(AbstractBean bean) {
        this.bean = bean;
    }

    public ServerIoListener() {
    }

    @Override
    public void onConnect(IoSessionWrapper session) {
    }

    @Override
    public void onDisConnect(IoSessionWrapper session) {
    }

    @Override
    public void onException(IoSessionWrapper session, Throwable t) {
        System.out.println(AppUtil.getUrl((InetSocketAddress)session.getRemoteAddress()) + ",\u670d\u52a1\u7aef\u5f02\u5e38" + t.getMessage());
    }

    public void onReceivedSerializableObj(Serializable obj, IoSessionWrapper session) {
    }

    @Override
    public void onReceived(Serializable obj, IoSessionWrapper session) {
        block45: {
            long start = System.currentTimeMillis();
            long start2 = 0L;
            if (obj instanceof Request) {
                Response ret = null;
                Request req = null;
                boolean isSuccess = true;
                long invoke_mills = 0L;
                Object result = null;
                boolean ignore = false;
                try {
                    try {
                        req = (Request)obj;
                        ret = new Response(req.getReqId(), req.getReqVersion());
                        if (req.getRemoteInterfaceClassName().equals(Standard.class.getName()) || req.getRemoteInterfaceClassName().equals(PushListener.class.getName()) || req.getRemoteInterfaceClassName().equals("com.yihu.guard.api.readRunState")) {
                            ignore = true;
                        }
                        if (!ignore) {
                            ServerRunner.getInstance().start();
                        }
                        if (req.getAttribute() != null) {
                            int i = 0;
                            while (i < req.getAttribute().length) {
                                session.setAttribute(req.getAttribute()[i].getName(), req.getAttribute()[i].getValue());
                                ++i;
                            }
                        }
                        ret.setStatus((byte)1);
                        Class<?> c = Class.forName(req.getRemoteInterfaceClassName());
                        Object object = map.get(c.getName());
                        if (object == null) {
                            if (c.equals(Standard.class)) {
                                object = standardImpl;
                            } else {
                                boolean isInterface = Class.forName(req.getRemoteInterfaceClassName()).isInterface();
                                if (!isInterface) {
                                    object = Class.forName(req.getRemoteInterfaceClassName()).newInstance();
                                } else if (this.bean != null) {
                                    object = this.bean.get(req, AppUtil.getUrl((InetSocketAddress)session.getRemoteAddress()), isInterface);
                                } else {
                                    throw new Exception("\u672a\u627e\u5230" + req.getRemoteInterfaceClassName() + "\u7684\u5b9e\u4f8b");
                                }
                            }
                            map.putIfAbsent(c.getName(), object);
                            object = map.get(c.getName());
                        }
                        MethodAccess ma = MethodAccessManager.getInstance().getMethodAccess(c);
                        int index = ma.getIndex(req.getMethodName(), req.getParamTypes());
                        result = ma.invoke(object, index, req.getArgs());
                        invoke_mills = System.currentTimeMillis() - start;
                        ret.setConsumeMills(invoke_mills);
                        ret.setResult(result);
                    }
                    catch (Exception ex) {
                        System.out.println(ex.getMessage());
                        ret.setStatus((byte)-1);
                        StringWriter sw = new StringWriter();
                        PrintWriter w = new PrintWriter(sw);
                        ex.printStackTrace(w);
                        ret.setErrorMsg(sw.toString());
                        isSuccess = false;
                        if (ret != null) {
                            try {
                                if (req.isReceiveResult()) {
                                    start2 = System.currentTimeMillis();
                                    session.write(ret);
                                }
                            }
                            catch (Exception ex2) {
                                System.out.println(ex2.getMessage());
                                ret.setStatus((byte)-1);
                                StringWriter sw2 = new StringWriter();
                                PrintWriter w2 = new PrintWriter(sw2);
                                ex2.printStackTrace(w2);
                                ret.setErrorMsg(sw2.toString());
                                isSuccess = false;
                            }
                        }
                        try {
                            if (ignore) break block45;
                            try {
                                ServerRunner.getInstance().end(System.currentTimeMillis() - start, isSuccess);
                                if (!req.getRemoteInterfaceClassName().equals(LogStandard.class.getName())) {
                                    String clientIp = AppUtil.getUrl((InetSocketAddress)session.getRemoteAddress()).toString();
                                    if (System.currentTimeMillis() - start >= (long)Server.RECORD_RESPONSE_SECONDS || !isSuccess) {
                                        Logger.get().info("response-log", LogBody.me().set("ClassName", req.getRemoteInterfaceClassName()).set("ReqId", req.getReqId()).set("MethodName", req.getMethodName()).set("Status", isSuccess).set("Mills", System.currentTimeMillis() - start).set("RealMills", start2 - start).set("ErrorMsg", ret.getErrorMsg()).set("ReturnType", ret.getResult().getClass()).set("IP", localIP).set("ClientIp", clientIp));
                                    }
                                    if (this.debug) {
                                        System.out.println(String.valueOf(req.getMethodName()) + ",from " + clientIp + ",mills=" + (System.currentTimeMillis() - start));
                                    }
                                }
                            }
                            catch (Exception clientIp) {}
                        }
                        catch (Exception clientIp) {}
                    }
                }
                finally {
                    block46: {
                        if (ret != null) {
                            try {
                                if (req.isReceiveResult()) {
                                    start2 = System.currentTimeMillis();
                                    session.write(ret);
                                }
                            }
                            catch (Exception ex) {
                                System.out.println(ex.getMessage());
                                ret.setStatus((byte)-1);
                                StringWriter sw = new StringWriter();
                                PrintWriter w = new PrintWriter(sw);
                                ex.printStackTrace(w);
                                ret.setErrorMsg(sw.toString());
                                isSuccess = false;
                            }
                        }
                        try {
                            if (ignore) break block46;
                            try {
                                ServerRunner.getInstance().end(System.currentTimeMillis() - start, isSuccess);
                                if (!req.getRemoteInterfaceClassName().equals(LogStandard.class.getName())) {
                                    String clientIp = AppUtil.getUrl((InetSocketAddress)session.getRemoteAddress()).toString();
                                    if (System.currentTimeMillis() - start >= (long)Server.RECORD_RESPONSE_SECONDS || !isSuccess) {
                                        Logger.get().info("response-log", LogBody.me().set("ClassName", req.getRemoteInterfaceClassName()).set("ReqId", req.getReqId()).set("MethodName", req.getMethodName()).set("Status", isSuccess).set("Mills", System.currentTimeMillis() - start).set("RealMills", start2 - start).set("ErrorMsg", ret.getErrorMsg()).set("ReturnType", ret.getResult().getClass()).set("IP", localIP).set("ClientIp", clientIp));
                                    }
                                    if (this.debug) {
                                        System.out.println(String.valueOf(req.getMethodName()) + ",from " + clientIp + ",mills=" + (System.currentTimeMillis() - start));
                                    }
                                }
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }
}

