/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting.reflect;

import com.coreframework.remoting.reflect.FutureTaskInfo;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class TimeoutThread
extends Thread {
    private static final long MILL_ORIGIN = System.currentTimeMillis();
    private volatile DelayQueue<TimeoutDelayed> queue = new DelayQueue();

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    TimeoutDelayed delay = (TimeoutDelayed)this.queue.take();
                    delay.doTimeout();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void addTask(FutureTaskInfo request, long timeout) {
        this.queue.put(new TimeoutDelayed(request, timeout));
    }

    public class TimeoutDelayed
    implements Delayed {
        private FutureTaskInfo request;
        private long now;
        private long timeout;

        public TimeoutDelayed(FutureTaskInfo request, long timeout) {
            this.request = request;
            this.timeout = timeout;
            this.now = System.currentTimeMillis() - MILL_ORIGIN;
        }

        public void doTimeout() {
            if (!this.request.getFutureTask().isDone()) {
                this.request.getFutureTask().cancel(true);
            }
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long currNow = System.currentTimeMillis() - MILL_ORIGIN;
            long d = unit.convert(this.now + this.timeout - currNow, TimeUnit.MILLISECONDS);
            return d;
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof TimeoutDelayed) {
                TimeoutDelayed x = (TimeoutDelayed)other;
                long diff = this.now + this.timeout - (x.now + x.timeout);
                return diff < 0L ? 1 : (diff > 0L ? 1 : (this.now > x.now ? 1 : -1));
            }
            long d = this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS);
            return d == 0L ? 0 : (d < 0L ? -1 : 1);
        }
    }
}

