/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting.sr;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CaseInsensitiveHashMap
extends HashMap<String, Object> {
    private final Map<String, String> lowerCaseMap = new HashMap<String, String>();
    private static final long serialVersionUID = -2848100435296897392L;

    @Override
    public boolean containsKey(Object key) {
        String realKey = this.lowerCaseMap.get(key.toString().toLowerCase());
        return super.containsKey(realKey);
    }

    @Override
    public Object get(Object key) {
        String realKey = this.lowerCaseMap.get(key.toString().toLowerCase());
        return super.get(realKey);
    }

    @Override
    public Object put(String key, Object value) {
        String oldKey = this.lowerCaseMap.put(key.toLowerCase(), key);
        Object oldValue = super.remove(oldKey);
        super.put(key, value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.put(key, value);
        }
    }

    @Override
    public Object remove(Object key) {
        String realKey = this.lowerCaseMap.remove(key.toString().toLowerCase());
        return super.remove(realKey);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.lowerCaseMap != null) {
            Iterator iterator = super.entrySet().iterator();
            Map.Entry current = null;
            while (iterator.hasNext()) {
                current = iterator.next();
                sb.append((String)current.getKey()).append("=").append(current.getValue());
                sb.append("|");
            }
        }
        return sb.toString();
    }
}

