/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting.sr;

import com.coreframework.remoting.sr.StatisticsProperty;
import java.util.concurrent.atomic.AtomicLong;

public class ServerRunner {
    private static ServerRunner instance = null;
    private static final Object lock = new Object();
    private static final AtomicLong current = new AtomicLong();
    private static final AtomicLong total = new AtomicLong();
    private static final AtomicLong overtime = new AtomicLong();
    private long maxActive;
    private long maxActiveTime;

    private ServerRunner() {
    }

    public void start() {
        long l = current.incrementAndGet();
        if (l > this.maxActive) {
            this.maxActive = l;
            this.maxActiveTime = System.currentTimeMillis();
        }
        total.incrementAndGet();
    }

    public void end(long mills, boolean isSuccess) {
        current.decrementAndGet();
    }

    public StatisticsProperty getRunStatistics() {
        StatisticsProperty s = new StatisticsProperty();
        s.setMaxActive(this.maxActive < 0L ? 0L : this.maxActive);
        long actives = current.get();
        s.setActives(actives < 0L ? 0L : actives);
        s.setTotal(total.get());
        s.setMaxActiveTime(this.maxActiveTime);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerRunner getInstance() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = new ServerRunner();
            }
            return instance;
        }
    }
}

