/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting.standard;

import com.coreframework.remoting.Url;
import com.coreframework.remoting.standard.ServiceProvider;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceLocalCache {
    private static ConcurrentHashMap<String, ServiceProvider> map = new ConcurrentHashMap();
    private static final Object lock = new Object();
    private static int servicePort;

    public static void setServicePort(int _servicePort) {
        servicePort = _servicePort;
    }

    public static int getServicePort() {
        return servicePort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(String key, ServiceProvider value) {
        Object object = lock;
        synchronized (object) {
            map.put(key, value);
        }
    }

    public static ServiceProvider pick(String serviceName) {
        ServiceProvider p = map.get(serviceName);
        return p;
    }

    public static boolean contains(String key) {
        return map.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(String key) {
        Object object = lock;
        synchronized (object) {
            map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll() {
        Object object = lock;
        synchronized (object) {
            map.clear();
        }
    }

    public static int size() {
        return map.size();
    }

    public static void remove(Url url) {
        Collection<ServiceProvider> col = map.values();
        for (ServiceProvider serviceProvider : col) {
            serviceProvider.getList().remove(url);
        }
    }

    public static String getLoaclServices() {
        Collection<ServiceProvider> col = map.values();
        StringBuffer sb = new StringBuffer();
        for (ServiceProvider serviceProvider : col) {
            sb.append(serviceProvider.getServiceName());
            sb.append("=>");
            List<Url> list = serviceProvider.getList();
            for (Url url : list) {
                sb.append(url.toString()).append(";");
            }
            sb.append("$");
        }
        return sb.toString();
    }
}

