/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.remoting.standard;

import com.coreframework.remoting.standard.DateOper;
import com.coreframework.remoting.standard.DiskInfo;
import com.coreframework.remoting.standard.JvmInfo;
import com.coreframework.remoting.standard.SysInfo;
import com.coreframework.remoting.standard.Usage;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;

public class SystemInfoUtil {
    private static SystemInfoUtil instance;

    private SystemInfoUtil() {
    }

    public static SystemInfoUtil getInstance() {
        if (instance == null) {
            instance = new SystemInfoUtil();
        }
        return instance;
    }

    public JvmInfo getJvmInfo() {
        JvmInfo info = new JvmInfo();
        List<MemoryPoolMXBean> mpmxbs = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean mpmxb : mpmxbs) {
            Usage usage;
            MemoryUsage musage;
            if (mpmxb.getName().equals("Eden Space") || mpmxb.getName().equals("PS Eden Space")) {
                musage = mpmxb.getUsage();
                usage = new Usage();
                usage.setCommitted(musage.getCommitted());
                usage.setInit(musage.getInit());
                usage.setMax(musage.getMax());
                usage.setUsed(musage.getUsed());
                info.setEdenSpace(usage);
                continue;
            }
            if (mpmxb.getName().equals("Tenured Gen") || mpmxb.getName().equals("PS Old Gen")) {
                musage = mpmxb.getUsage();
                usage = new Usage();
                usage.setCommitted(musage.getCommitted());
                usage.setInit(musage.getInit());
                usage.setMax(musage.getMax());
                usage.setUsed(musage.getUsed());
                info.setTenuredGen(usage);
                continue;
            }
            if (!mpmxb.getName().equals("Perm Gen") && !mpmxb.getName().equals("PS Perm Gen")) continue;
            musage = mpmxb.getUsage();
            usage = new Usage();
            usage.setCommitted(musage.getCommitted());
            usage.setInit(musage.getInit());
            usage.setMax(musage.getMax());
            usage.setUsed(musage.getUsed());
            info.setPermGen(usage);
        }
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        MemoryUsage musage = memory.getHeapMemoryUsage();
        Usage usage = new Usage();
        usage.setCommitted(musage.getCommitted());
        usage.setInit(musage.getInit());
        usage.setMax(musage.getMax());
        usage.setUsed(musage.getUsed());
        info.setHeapMemoryUsage(usage);
        musage = memory.getNonHeapMemoryUsage();
        usage = new Usage();
        usage.setCommitted(musage.getCommitted());
        usage.setInit(musage.getInit());
        usage.setMax(musage.getMax());
        usage.setUsed(musage.getUsed());
        info.setNonHeapMemoryUsage(usage);
        RuntimeMXBean rtmxb = ManagementFactory.getRuntimeMXBean();
        long timespan = rtmxb.getUptime();
        info.setUptime(timespan);
        info.setName(rtmxb.getName());
        ThreadMXBean tbean = ManagementFactory.getThreadMXBean();
        int threadCount = tbean.getThreadCount();
        info.setThreadCount(threadCount);
        return info;
    }

    public static void main(String[] args) {
        while (true) {
            long t = System.currentTimeMillis();
            System.out.println(SystemInfoUtil.getInstance().getSysInfo().getFreePhysicalMemorySize());
            System.out.println(System.currentTimeMillis() - t);
        }
    }

    private static SysInfo getsysinfo() {
        SysInfo sysInfo = new SysInfo();
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long totalSwapSpaceSize = osmxb.getTotalSwapSpaceSize();
        long totalPhysicalMemorySize = osmxb.getTotalPhysicalMemorySize();
        long freePhysicalMemorySize = osmxb.getFreePhysicalMemorySize();
        long committedVirtualMemorySize = osmxb.getCommittedVirtualMemorySize();
        Double compare = Double.valueOf(1.0 - (double)freePhysicalMemorySize * 1.0 / (double)totalSwapSpaceSize) * 100.0;
        String time = DateOper.getNowDateTime().toString();
        sysInfo.setTotalPhysicalMemorySize(totalPhysicalMemorySize);
        sysInfo.setTotalSwapSpaceSize(totalSwapSpaceSize);
        sysInfo.setMemoryPoint(compare.intValue());
        sysInfo.setCommittedVirtualMemorySize(committedVirtualMemorySize);
        sysInfo.setFreePhysicalMemorySize(freePhysicalMemorySize);
        sysInfo.setTotalSwapSpaceSize(totalSwapSpaceSize);
        sysInfo.setName(String.valueOf(osmxb.getName()) + " " + osmxb.getArch());
        sysInfo.setTime(time);
        sysInfo.setDiskInfos(SystemInfoUtil.getDiskInfos());
        return sysInfo;
    }

    public SysInfo getSysInfo() {
        return SystemInfoUtil.getsysinfo();
    }

    private static DiskInfo[] getDiskInfos() {
        ArrayList<DiskInfo> list = new ArrayList<DiskInfo>();
        char c = 'A';
        while (c <= 'Z') {
            String dirName = String.valueOf(c) + ":/";
            File win = new File(dirName);
            if (win.exists()) {
                long total = win.getTotalSpace();
                long free = win.getFreeSpace();
                Double compare = Double.valueOf(1.0 - (double)free * 1.0 / (double)total) * 100.0;
                DiskInfo info = new DiskInfo();
                info.setDiskname(String.valueOf(c));
                info.setFreeSize(free);
                info.setTotalSize(total);
                info.setUsedPoint(compare.intValue());
                list.add(info);
            }
            c = (char)(c + '\u0001');
        }
        return list.toArray(new DiskInfo[list.size()]);
    }
}

