/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.wsgw.api;

import com.coreframework.log.LogBody;
import com.coreframework.log.Logger;
import com.coreframework.vo.ReturnValue;
import com.yihu.config.ConfigReader;
import com.yihu.monitor.sdk.NetworkUtil;
import com.yihu.wsgw.api.AsyncException;
import com.yihu.wsgw.api.DispatcherRunnable;
import com.yihu.wsgw.api.MqListenerImpl;
import com.yihu.wsgw.api.ReqInfo;
import com.yihu.wsgw.api.RouteParseUtil;
import com.yihu.wsgw.api.TaskHsqlDb;
import com.yihu.wsgw.api.UUIDGenerator;
import com.yihu.wsgw.mq.JmsReceiver;
import com.yihu.wsgw.mq.JmsSender;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AsyncBus {
    private static AsyncBus instance;
    private static Object _lock;
    private String localIP;
    private String zkService;
    private String appId;
    public static final int RECORD_SEND_SECONDS = 100;
    public static final int Group_One = 1;
    public static final int Group_Two = 2;
    private SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    static {
        _lock = new Object();
    }

    public AsyncBus(String zkService, String appId) {
        try {
            RouteParseUtil.getInstance(zkService);
            this.localIP = NetworkUtil.getLocalIP();
            this.zkService = zkService;
            this.appId = appId;
            if (this.localIP == null) {
                this.localIP = "0.0.0.0";
            }
            String[] mqUrl = null;
            try {
                mqUrl = ConfigReader.me((String)this.zkService).getNamePair("producerMQ").split(",");
                if (mqUrl != null) {
                    String[] stringArray = mqUrl;
                    int n = mqUrl.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String brokerUrl = stringArray[n2];
                        JmsSender.get(brokerUrl);
                        ++n2;
                    }
                }
            }
            catch (Exception e2) {
                throw new AsyncException(e2.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AsyncBus(String appId) {
        try {
            this.localIP = NetworkUtil.getLocalIP();
            this.appId = appId;
            if (this.localIP == null) {
                this.localIP = "0.0.0.0";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncBus get(String zkService, String clientId) {
        if (instance == null) {
            Object object = _lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new AsyncBus(zkService, clientId);
                }
            }
        }
        return instance;
    }

    @Deprecated
    public void startListen(String queueName, String ipMatch, int count) {
        if (this.localIP.indexOf(ipMatch) != 0) {
            System.out.println("\u5f53\u524d\u670d\u52a1\u5668IP\u4e0d\u5339\u914d,\u672a\u5f00\u542f\u76d1\u542c");
            return;
        }
        String[] mqUrl = null;
        try {
            mqUrl = ConfigReader.me((String)this.zkService).getNamePair("consumerMQ").split(",");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return;
        }
        String[] stringArray = mqUrl;
        int n = mqUrl.length;
        int n2 = 0;
        while (n2 < n) {
            String brokerUrl = stringArray[n2];
            try {
                int i = 0;
                while (i < count) {
                    JmsReceiver.startListener(brokerUrl, queueName, new MqListenerImpl(this.zkService, this.appId, this.localIP));
                    System.out.println("\u6210\u529f\u76d1\u542c\u961f\u5217:" + brokerUrl + ":" + queueName + ":" + (i + 1));
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("\u542f\u52a8\u76d1\u542c\u5931\u8d25!");
            }
            ++n2;
        }
    }

    @Deprecated
    public void startListen(String queueName, String ipMatch) {
        this.startListen(queueName, ipMatch, 1);
    }

    public void startDispatcher(int groupID, boolean isSerial) {
        TaskHsqlDb.get().initTaskTable();
        Thread t = new Thread(new DispatcherRunnable(this.zkService, this.localIP, this.appId, groupID, isSerial));
        t.setName("A-Async-DispatcherRunnable-" + groupID);
        t.start();
    }

    public ReturnValue sendCall(String api, String params) {
        return this.sendCall(api, params, 0, 0, "1", 1);
    }

    public ReturnValue sendCall(String api, String params, int groupID) {
        return this.sendCall(api, params, 0, 0, "1", groupID);
    }

    public ReturnValue sendCall(String api, Class<?> c, String methodName, String paramJson) {
        return this.sendCall(api, c, methodName, paramJson, 0, 0, "1", 2);
    }

    public ReturnValue sendCall(String api, Class<?> c, String methodName, String paramJson, int groupID) {
        return this.sendCall(api, c, methodName, paramJson, 0, 0, "1", groupID);
    }

    public ReturnValue sendCall(String api, String param, int paramType, int outType, String v, int groupID) {
        String seq = UUIDGenerator.generate();
        ReqInfo reqInfo = new ReqInfo();
        reqInfo.setApi(api);
        reqInfo.setAuthInfo("{\"SessionKey\":\"\",\"Sign\":\"\",\"ClientVersion\":\"1\",\"ClientId\":\"" + this.appId + "\"}");
        reqInfo.setClientIp(this.localIP);
        reqInfo.setOutType(outType);
        reqInfo.setParam(param);
        reqInfo.setParamType(paramType);
        reqInfo.setSendTime(this.sf.format(new Date()));
        reqInfo.setSequenceNo(seq);
        reqInfo.setV(v);
        reqInfo.setGroupID(groupID);
        try {
            TaskHsqlDb.get().insertTaskTable(reqInfo);
            return new ReturnValue(10000, "\u6210\u529f");
        }
        catch (SQLException e) {
            return new ReturnValue(-14444, e.getMessage());
        }
    }

    public ReturnValue sendCall(String api, Class<?> c, String methodName, String param, int paramType, int outType, String v, int groupID) {
        String seq = UUIDGenerator.generate();
        ReqInfo reqInfo = new ReqInfo();
        reqInfo.setApi(api);
        reqInfo.setAuthInfo("{\"SessionKey\":\"\",\"Sign\":\"\",\"ClientVersion\":\"1\",\"ClientId\":\"" + this.appId + "\"}");
        reqInfo.setClientIp(this.localIP);
        reqInfo.setOutType(outType);
        reqInfo.setParam(param);
        reqInfo.setParamType(paramType);
        reqInfo.setSendTime(new Timestamp(System.currentTimeMillis()).toString());
        reqInfo.setSequenceNo(seq);
        reqInfo.setV(v);
        reqInfo.setC(c);
        reqInfo.setMethodName(methodName);
        reqInfo.setGroupID(groupID);
        try {
            TaskHsqlDb.get().insertTaskTable(reqInfo);
            return new ReturnValue(10000, "\u6210\u529f");
        }
        catch (SQLException e) {
            Logger.get().error("async-request-log", LogBody.me().set(e).set("req", reqInfo));
            return new ReturnValue(-14444, e.getMessage());
        }
    }
}

