/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.wsgw.api;

import com.common.json.JSONException;
import com.common.json.JSONObject;
import com.coreframework.log.FileLogOper;
import com.coreframework.vo.ReturnValue;
import com.yihu.config.ConfigReader;
import com.yihu.wsgw.api.CallLog;
import com.yihu.wsgw.api.ReqInfo;
import com.yihu.wsgw.api.WsUtil;
import com.yihu.wsgw.mq.JmsSender;
import java.util.ArrayList;
import java.util.List;

public class AsyncCallLog {
    private static final List<String> unLog = new ArrayList<String>();

    public static void addWithOutLog(String api) {
        unLog.add(api);
    }

    public static void sendErrorLog(String zkService, ReqInfo reqInfo, String acceptorId, String acceptorIp, String acceptorTime, int code, String message) {
        CallLog callLog = new CallLog(reqInfo);
        callLog.setAcceptorId(acceptorId);
        callLog.setAcceptorIp(acceptorIp);
        callLog.setAcceptorTime(acceptorTime);
        callLog.setResult(AsyncCallLog.getRetVal(reqInfo.getOutType(), code, message));
        AsyncCallLog.sendLog(zkService, callLog);
    }

    public static String getRetVal(int outType, int code, String message) {
        if (outType == 0) {
            JSONObject json = new JSONObject();
            try {
                json.put("Code", code);
                json.put("Message", message);
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
            return json.toString();
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><OutPut><Code>" + code + "</Code><Message>" + message + "</Message></OutPut>";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sendLog(String zkService, CallLog callLog) {
        String brokerUrl;
        String errormsg;
        boolean success;
        block12: {
            block11: {
                success = true;
                errormsg = null;
                brokerUrl = null;
                if (!unLog.contains(callLog.getApi()) || WsUtil.getReturnValue(callLog.getResult()).getCode() != 10000) break block11;
                if (success) return;
                ReturnValue rv = WsUtil.getReturnValue(callLog.getResult());
                FileLogOper.write("async-log-error.log", String.valueOf(brokerUrl == null ? "" : brokerUrl) + "\t" + (errormsg == null ? "" : errormsg) + "\t" + callLog.getApi() + "\t" + callLog.getParam() + "\t" + callLog.getClientIp() + "\t" + callLog.getSendTime() + "\t" + rv.getCode() + "\t" + rv.getMessage());
                return;
            }
            String[] mqUrl = null;
            try {
                mqUrl = ConfigReader.me((String)zkService).getNamePair("producerMQ").split(",");
            }
            catch (Exception e2) {
                e2.printStackTrace();
                errormsg = e2.getMessage();
                if (success) return;
                ReturnValue rv = WsUtil.getReturnValue(callLog.getResult());
                FileLogOper.write("async-log-error.log", String.valueOf(brokerUrl == null ? "" : brokerUrl) + "\t" + (errormsg == null ? "" : errormsg) + "\t" + callLog.getApi() + "\t" + callLog.getParam() + "\t" + callLog.getClientIp() + "\t" + callLog.getSendTime() + "\t" + rv.getCode() + "\t" + rv.getMessage());
                return;
            }
            try {
                try {
                    brokerUrl = mqUrl[0];
                    JmsSender.get(mqUrl[0]).sendTextMessage("AsyncLog", callLog.toString());
                }
                catch (Exception e) {
                    if (mqUrl.length == 2) {
                        brokerUrl = mqUrl[1];
                        JmsSender.get(mqUrl[1]).sendTextMessage("AsyncLog", callLog.toString());
                        break block12;
                    }
                    errormsg = e.getMessage();
                    if (success) return;
                    ReturnValue rv = WsUtil.getReturnValue(callLog.getResult());
                    FileLogOper.write("async-log-error.log", String.valueOf(brokerUrl == null ? "" : brokerUrl) + "\t" + (errormsg == null ? "" : errormsg) + "\t" + callLog.getApi() + "\t" + callLog.getParam() + "\t" + callLog.getClientIp() + "\t" + callLog.getSendTime() + "\t" + rv.getCode() + "\t" + rv.getMessage());
                    return;
                }
            }
            catch (Exception ee) {
                try {
                    ee.printStackTrace();
                    errormsg = ee.getMessage();
                    if (success) return;
                }
                catch (Throwable throwable) {
                    if (success) throw throwable;
                    ReturnValue rv = WsUtil.getReturnValue(callLog.getResult());
                    FileLogOper.write("async-log-error.log", String.valueOf(brokerUrl == null ? "" : brokerUrl) + "\t" + (errormsg == null ? "" : errormsg) + "\t" + callLog.getApi() + "\t" + callLog.getParam() + "\t" + callLog.getClientIp() + "\t" + callLog.getSendTime() + "\t" + rv.getCode() + "\t" + rv.getMessage());
                    throw throwable;
                }
                ReturnValue rv = WsUtil.getReturnValue(callLog.getResult());
                FileLogOper.write("async-log-error.log", String.valueOf(brokerUrl == null ? "" : brokerUrl) + "\t" + (errormsg == null ? "" : errormsg) + "\t" + callLog.getApi() + "\t" + callLog.getParam() + "\t" + callLog.getClientIp() + "\t" + callLog.getSendTime() + "\t" + rv.getCode() + "\t" + rv.getMessage());
                return;
            }
        }
        if (success) return;
        ReturnValue rv = WsUtil.getReturnValue(callLog.getResult());
        FileLogOper.write("async-log-error.log", String.valueOf(brokerUrl == null ? "" : brokerUrl) + "\t" + (errormsg == null ? "" : errormsg) + "\t" + callLog.getApi() + "\t" + callLog.getParam() + "\t" + callLog.getClientIp() + "\t" + callLog.getSendTime() + "\t" + rv.getCode() + "\t" + rv.getMessage());
    }
}

