/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.wsgw.api;

import com.yihu.wsgw.api.AsyncCallLog;
import com.yihu.wsgw.api.CallLog;
import com.yihu.wsgw.api.InterfaceMessage;
import com.yihu.wsgw.api.ReqInfo;
import com.yihu.wsgw.api.RouteParseUtil;
import com.yihu.wsgw.api.WsUtil;
import com.yihu.wsgw.vo.MappingRouteVo;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.activemq.command.ActiveMQTextMessage;

public class MqListenerImpl
implements MessageListener {
    private static final ConcurrentHashMap<Class<?>, Object> map = new ConcurrentHashMap();
    private String zkService;
    private String appId;
    private String localIp;

    public MqListenerImpl(String zkService, String appId, String localIp) {
        this.zkService = zkService;
        this.appId = appId;
        this.localIp = localIp;
    }

    private String localExec(InterfaceMessage message, Class<?> c, String methodName) {
        try {
            Object obj = map.get(c);
            if (obj == null) {
                map.put(c, c.newInstance());
                obj = map.get(c);
            }
            Method method = c.getMethod(methodName, InterfaceMessage.class);
            String ret = (String)method.invoke(obj, message);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return WsUtil.getRetVal(message.getOutType(), -14444, e.getMessage());
        }
    }

    public void onMessage(Message arg0) {
        if (arg0 instanceof ActiveMQTextMessage) {
            long start = System.currentTimeMillis();
            ActiveMQTextMessage mes = (ActiveMQTextMessage)arg0;
            ReqInfo reqInfo = null;
            try {
                reqInfo = new ReqInfo(mes.getText());
            }
            catch (JMSException e) {
                e.printStackTrace();
                AsyncCallLog.sendErrorLog(this.zkService, reqInfo, this.appId, this.localIp, new Timestamp(System.currentTimeMillis()).toString(), -14444, e.getMessage());
                return;
            }
            Class<?> c = null;
            String methodName = null;
            if (reqInfo.getC() == null || reqInfo.getMethodName() == null) {
                MappingRouteVo vo = null;
                try {
                    vo = RouteParseUtil.getInstance(this.zkService).queryMappingRouteVo(reqInfo.getApi(), reqInfo.getParam());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    AsyncCallLog.sendErrorLog(this.zkService, reqInfo, this.appId, this.localIp, new Timestamp(System.currentTimeMillis()).toString(), -14444, e1.getMessage());
                    return;
                }
                String className = vo.getRemoteClass();
                String[] tmp = reqInfo.getApi().split("\\.");
                methodName = tmp[2];
                try {
                    c = Class.forName(className);
                }
                catch (ClassNotFoundException e2) {
                    AsyncCallLog.sendErrorLog(this.zkService, reqInfo, this.appId, this.localIp, new Timestamp(System.currentTimeMillis()).toString(), -14444, e2.getClass() + ":" + e2.getMessage());
                    return;
                }
            }
            c = reqInfo.getC();
            methodName = reqInfo.getMethodName();
            if (c != null && methodName != null) {
                InterfaceMessage message = new InterfaceMessage();
                message.setAuthInfo(reqInfo.getAuthInfo());
                message.setApiName(reqInfo.getApi());
                message.setOutType(reqInfo.getOutType());
                message.setParamType(reqInfo.getParamType());
                message.setVersion(reqInfo.getV());
                message.setParam(reqInfo.getParam());
                message.setSeq(reqInfo.getSequenceNo());
                String result = this.localExec(message, c, methodName);
                CallLog callLog = new CallLog(reqInfo);
                callLog.setAcceptorId(this.appId);
                callLog.setAcceptorIp(this.localIp);
                callLog.setAcceptorTime(new Timestamp(start).toString());
                callLog.setResult(result);
                callLog.setMills(System.currentTimeMillis() - start);
                AsyncCallLog.sendLog(this.zkService, callLog);
            } else {
                System.out.println(c);
                System.out.println(methodName);
            }
            reqInfo = null;
            mes = null;
        }
    }
}

