/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.wsgw.api;

import com.coreframework.log.LogBody;
import com.coreframework.log.Logger;
import com.coreframework.remoting.Url;
import com.yihu.config.ConfigReader;
import com.yihu.wsgw.api.FileTypeFilter;
import com.yihu.wsgw.vo.MappingRouteVo;
import com.yihu.wsgw.vo.RouteApiVo;
import com.yihu.wsgw.vo.RouteModuleVo;
import com.yihu.wsgw.vo.RouteParamVo;
import com.yihu.wsgw.vo.RouteVo;
import com.yihu.zk.AbstractZKListener;
import com.yihu.zk.ZkClientFactory;
import com.yihu.zk.ZkClientWrapper;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.I0Itec.zkclient.ZkClient;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class RouteParseUtil {
    private static volatile RouteParseUtil instance = null;
    private static Map<String, Map<String, String>> zkServiceMap = new HashMap<String, Map<String, String>>();
    private static Map<String, RouteVo> zkRouteMap = new HashMap<String, RouteVo>();
    private static String rootPath = "/ApiRouteRoot";
    private static final String charsetName = "GBK";
    private String zkService;
    private ZkClientWrapper wrapper = null;
    private ZkClient zkClient = null;
    private String Config = "Config";
    private String Mapping = "Mapping";
    private String Route = "Route";
    private String module = "module";
    private String api = "api";
    private String param = "param";
    private String url = "url";
    private String proxyUrl = "proxyUrl";
    private String name = "name";
    private String value = "value";
    private String remoteClass = "remoteClass";

    public MappingRouteVo queryMappingRouteVo(String api, String paramJson) throws Exception {
        MappingRouteVo mappingRouteVo = null;
        mappingRouteVo = this.queryMappingRouteVoByLoc(api, paramJson);
        if (mappingRouteVo == null) {
            Logger.get().error("ZK-ERROR", LogBody.me().set("api", paramJson).set("paramJson", paramJson).set("msg", "\u672c\u5730\u672a\u627e\u5230"));
            mappingRouteVo = this.queryMappingRouteVoByZk(api, paramJson);
            if (mappingRouteVo == null) {
                Logger.get().error("ZK-ERROR", LogBody.me().set("api", paramJson).set("paramJson", paramJson).set("msg", "\u8fdc\u7a0b\u672a\u627e\u5230"));
            }
        } else if (mappingRouteVo.remoteClass == null) {
            mappingRouteVo = this.queryMappingRouteVoByZk(api, paramJson);
        }
        return mappingRouteVo;
    }

    private MappingRouteVo queryMappingRouteVoByLoc(String api, String paramJson) throws Exception {
        String proxyUrl;
        String url;
        String remoteClass;
        block24: {
            String[] tmp = api.split("\\.");
            remoteClass = null;
            Map<String, String> serviceMap = zkServiceMap.get(String.valueOf(rootPath) + "/" + tmp[0]);
            if (serviceMap != null) {
                if (serviceMap.get(api) != null && !"".equals(serviceMap.get(api))) {
                    remoteClass = serviceMap.get(api);
                } else if (serviceMap.get(String.valueOf(tmp[0]) + "." + tmp[1]) != null) {
                    remoteClass = serviceMap.get(String.valueOf(tmp[0]) + "." + tmp[1]);
                }
            }
            url = null;
            proxyUrl = null;
            RouteVo routeVo = zkRouteMap.get(String.valueOf(rootPath) + "/" + tmp[0]);
            if (routeVo != null) {
                Map<String, RouteApiVo> apiMap = routeVo.getApiMap();
                Map<String, RouteModuleVo> moduleMap = routeVo.getModuleMap();
                if (apiMap != null && apiMap.get(api) != null) {
                    RouteApiVo routeApiVo = apiMap.get(api);
                    url = routeApiVo.getUrl();
                    proxyUrl = routeApiVo.getProxyUrl();
                    List<RouteParamVo> paramList = routeApiVo.getList();
                    if (paramList != null && paramList.size() > 0) {
                        for (RouteParamVo routeParamVo : paramList) {
                            String paramName = routeParamVo.getParamName();
                            String paramValue = routeParamVo.getParamValue();
                            try {
                                String paramV;
                                JSONObject jo = JSONObject.fromObject((Object)paramJson);
                                if (!jo.has(paramName) || !paramValue.equals(paramV = String.valueOf(jo.get(paramName)))) continue;
                                url = routeParamVo.getUrl();
                                proxyUrl = routeParamVo.getProxyUrl();
                                break;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else if (moduleMap != null && moduleMap.get(String.valueOf(tmp[0]) + "." + tmp[1]) != null) {
                    RouteModuleVo routeModuleVo = moduleMap.get(String.valueOf(tmp[0]) + "." + tmp[1]);
                    if (routeModuleVo != null) {
                        url = routeModuleVo.getUrl();
                        proxyUrl = routeModuleVo.getProxyUrl();
                    }
                } else {
                    url = routeVo.getUrl();
                    proxyUrl = routeVo.getProxyUrl();
                }
            }
            if (url != null) break block24;
            return null;
        }
        try {
            String[] urlTmp = url.split(",");
            HashSet<Url> set = new HashSet<Url>();
            StringBuilder msg = null;
            String[] stringArray = urlTmp;
            int n = urlTmp.length;
            int routeParamVo = 0;
            while (routeParamVo < n) {
                String str = stringArray[routeParamVo];
                if (!"".equals(str.trim())) {
                    try {
                        Url u = this.getUrl(str);
                        set.add(u);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (msg == null) {
                            msg = new StringBuilder();
                        }
                        msg.append("\u3010" + e.getMessage() + "\u3011");
                    }
                }
                ++routeParamVo;
            }
            Url[] urlArray = new Url[set.size()];
            set.toArray(urlArray);
            if (msg != null) {
                int cfr_ignored_0 = urlArray.length;
            }
            MappingRouteVo mappingRouteVo = new MappingRouteVo(remoteClass, urlArray, this.getProxyUrl(proxyUrl));
            return mappingRouteVo;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter w = new PrintWriter(sw);
            e.printStackTrace(w);
            Logger.get().error(this.getClass().getSimpleName(), new LogBody().set("\u65b9\u6cd5", Thread.currentThread().getStackTrace()[1].getMethodName()).set("\u5f02\u5e38", sw.toString()));
            throw e;
        }
    }

    private MappingRouteVo queryMappingRouteVoByZk(String api, String paramJson) throws Exception {
        try {
            MappingRouteVo mappingRouteVo = new MappingRouteVo();
            String[] tmp = api.split("\\.");
            String nodeName = tmp[0];
            String nodePath = String.valueOf(rootPath) + "/" + tmp[0];
            Object obj = this.zkClient.readData(nodePath, true);
            if (obj != null) {
                byte[] b_nodeValue = (byte[])obj;
                String nodeValue = new String(b_nodeValue, charsetName);
                this.parseXmlNode(nodePath, nodeName, nodeValue);
                mappingRouteVo = this.queryMappingRouteVoByLoc(api, paramJson);
            }
            return mappingRouteVo;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter w = new PrintWriter(sw);
            e.printStackTrace(w);
            Logger.get().error(this.getClass().getSimpleName(), new LogBody().set("\u65b9\u6cd5", Thread.currentThread().getStackTrace()[1].getMethodName()).set("\u5f02\u5e38", sw.toString()));
            throw e;
        }
    }

    private RouteParseUtil(String zkService) throws Exception {
        this.zkService = zkService;
        System.out.println("=============\u521d\u59cb\u5316ZK\u6570\u636e begin=============");
        this.createZkClient(this.zkService);
        int flag = this.getDataByZk();
        System.out.println("=============\u521d\u59cb\u5316ZK\u6570\u636e end=============");
        if (flag == 1) {
            return;
        }
        this.wrapper.subscribePath(rootPath, new AbstractZKListener(){

            public void handleDataChange(String dataPath, Object data) throws Exception {
                System.out.println("handleDataChange:" + dataPath);
                System.out.println("handleDataChange-data:" + dataPath);
                if (data instanceof byte[]) {
                    System.out.println(new String((byte[])data, RouteParseUtil.charsetName));
                }
                String nodeName = dataPath.replace(rootPath, "");
                RouteParseUtil.this.parseXmlNode(dataPath, nodeName, new String((byte[])data, RouteParseUtil.charsetName));
                System.out.println("ZK\u6570\u636e\u66f4\u65b0\u6210\u529f\uff01");
            }

            public void handleDataDeleted(String dataPath) throws Exception {
                System.out.println("handleDataDeleted:" + dataPath);
            }

            public void handleChildChange(String parentPath, List<String> currentChilds) throws Exception {
                System.out.println("handleChildChange:" + parentPath);
                HashSet<String> currentSet = new HashSet<String>();
                for (String string : currentChilds) {
                    System.out.println(string);
                    currentSet.add(String.valueOf(parentPath) + "/" + string);
                }
                Set serviceSet = zkServiceMap.keySet();
                HashSet<String> currentSetMore = new HashSet<String>();
                HashSet currentSetLess = new HashSet();
                HashSet serviceSetClone = new HashSet();
                HashSet<String> currentSetClone = new HashSet<String>();
                serviceSetClone.addAll(serviceSet);
                currentSetClone.addAll(currentSet);
                currentSetMore.addAll(currentSet);
                currentSetLess.addAll(serviceSet);
                currentSetMore.removeAll(serviceSetClone);
                currentSetLess.removeAll(currentSetClone);
                System.out.println("currentSetMore---" + currentSetMore.size());
                for (String nodePath : currentSetMore) {
                    System.out.println(nodePath);
                    RouteParseUtil.this.wrapper.subscribePath(nodePath, new AbstractZKListener(){

                        public void handleDataChange(String dataPath, Object data) throws Exception {
                            System.out.println("\u5d4c\u5957\u5b50\u8282\u70b9\u76d1\u63a7handleDataChange:" + dataPath);
                            System.out.println("\u5d4c\u5957\u5b50\u8282\u70b9\u76d1\u63a7handleDataChange-data:" + dataPath);
                            if (data instanceof byte[]) {
                                System.out.println(new String((byte[])data, RouteParseUtil.charsetName));
                            }
                            String nodeName = dataPath.replace(rootPath, "");
                            RouteParseUtil.this.parseXmlNode(dataPath, nodeName, new String((byte[])data, RouteParseUtil.charsetName));
                            System.out.println("\u5d4c\u5957\u5b50\u8282\u70b9\u76d1\u63a7--ZK\u6570\u636e\u66f4\u65b0\u6210\u529f\uff01");
                        }

                        public void handleDataDeleted(String dataPath) throws Exception {
                        }

                        public void handleChildChange(String parentPath, List<String> currentChilds) throws Exception {
                        }
                    });
                    Object obj = RouteParseUtil.this.zkClient.readData(nodePath, true);
                    if (obj == null) continue;
                    byte[] b_nodeValue = (byte[])obj;
                    String nodeValue = new String(b_nodeValue, RouteParseUtil.charsetName);
                    String nodeName = nodePath.replace(rootPath, "");
                    RouteParseUtil.this.parseXmlNode(nodePath, nodeName, nodeValue);
                }
                System.out.println("currentSetLess---" + currentSetLess.size());
                for (String nodePath : currentSetLess) {
                    System.out.println(nodePath);
                    zkServiceMap.remove(nodePath);
                    zkRouteMap.remove(nodePath);
                }
            }
        });
        System.out.println("=============\u5efa\u7acbZK\u6570\u636e\u76d1\u542c\u5b8c\u6210=============");
    }

    private File[] getLocalRouteCfg(String routeCfgFileName) {
        File[] files;
        File directory;
        URL url = Thread.currentThread().getContextClassLoader().getResource("");
        if (url != null) {
            String path = url.getPath();
            try {
                path = URLDecoder.decode(path, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            directory = new File(path);
            files = directory.listFiles(new FileTypeFilter(String.valueOf(routeCfgFileName) + ".router.xml"));
            if (files != null) {
                return files;
            }
        }
        String tmp = this.getClass().getResource("").getPath();
        try {
            tmp = URLDecoder.decode(tmp, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        directory = new File(tmp);
        tmp = String.valueOf(directory.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getPath().replaceAll("file:", "")) + "\\lib\\classes";
        directory = new File(tmp);
        files = directory.listFiles(new FileTypeFilter(String.valueOf(routeCfgFileName) + ".router.xml"));
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RouteParseUtil getInstance(String zkService) throws Exception {
        if (instance != null) return instance;
        Class<RouteParseUtil> clazz = RouteParseUtil.class;
        synchronized (RouteParseUtil.class) {
            if (instance != null) return instance;
            instance = new RouteParseUtil(zkService);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private void createZkClient(String zkService) throws Exception {
        System.out.println("zk\u670d\u52a1\u5668\uff1a" + zkService);
        this.wrapper = ZkClientFactory.getInstance().getZkClient(zkService);
        this.zkClient = this.wrapper.getZkClient();
    }

    private int getDataByZk() throws Exception {
        List list = this.zkClient.getChildren(rootPath);
        int flag = 0;
        if (list != null && list.size() > 0) {
            int i = 0;
            for (String nodeName : list) {
                ++i;
                File[] files = this.getLocalRouteCfg(nodeName);
                if (files != null && files.length > 0) {
                    System.out.println("\u672c\u5730\u5b58\u5728\uff1a" + nodeName);
                    SAXReader reader = new SAXReader();
                    Document doc = reader.read(files[0]);
                    this.parseXmlNode(String.valueOf(rootPath) + "/" + nodeName, nodeName, doc.asXML());
                    flag = 1;
                    continue;
                }
                Object obj = this.zkClient.readData(String.valueOf(rootPath) + "/" + nodeName, true);
                if (obj == null) continue;
                byte[] b_nodeValue = (byte[])obj;
                String nodeValue = new String(b_nodeValue, charsetName);
                this.parseXmlNode(String.valueOf(rootPath) + "/" + nodeName, nodeName, nodeValue);
            }
        }
        return flag;
    }

    private void parseXmlNode(String nodePath, String nodeName, String nodeValue) throws Exception {
        Document doc = null;
        Element element22 = null;
        String xPath = "";
        String url = null;
        String proxyUrl = null;
        HashMap<String, String> serviceMap = new HashMap<String, String>();
        RouteVo routeVo = new RouteVo();
        try {
            List apiList;
            doc = DocumentHelper.parseText((String)nodeValue);
            Element root = doc.getRootElement();
            xPath = "/" + this.Config + "/" + this.Mapping;
            List mappingList = root.selectNodes(xPath);
            Element mappingElement = (Element)mappingList.get(0);
            List mappingModuleList = mappingElement.selectNodes(this.module);
            if (mappingModuleList.size() > 0) {
                for (Element element22 : mappingModuleList) {
                    List mappingApiList;
                    String key = element22.attributeValue(this.name);
                    if (key != null && !"".equals(key)) {
                        String val = element22.attributeValue(this.remoteClass);
                        serviceMap.put(key, val);
                    }
                    if ((mappingApiList = element22.selectNodes(this.api)).size() <= 0) continue;
                    for (Element element1 : mappingApiList) {
                        String key1 = element1.attributeValue(this.name);
                        if (key1 == null || "".equals(key1)) continue;
                        String val1 = element1.attributeValue(this.remoteClass);
                        serviceMap.put(key1, val1);
                    }
                }
            }
            xPath = "/" + this.Config + "/" + this.Route;
            List routeList = root.selectNodes(xPath);
            Element routeNode = (Element)routeList.get(0);
            String p_url = routeNode.attributeValue("url");
            String p_proxyUrl = routeNode.attributeValue("proxyUrl");
            routeVo.setUrl(p_url);
            routeVo.setProxyUrl(p_proxyUrl);
            xPath = "/" + this.Config + "/" + this.Route + "/" + this.module;
            List moduleList = root.selectNodes(xPath);
            if (moduleList.size() > 0) {
                HashMap<String, RouteModuleVo> moduleMap = new HashMap<String, RouteModuleVo>();
                for (Element element22 : moduleList) {
                    String key = element22.attributeValue(this.name);
                    if (key == null || "".equals(key)) continue;
                    RouteModuleVo routeModuleVo = new RouteModuleVo();
                    url = element22.attributeValue(this.url);
                    proxyUrl = element22.attributeValue(this.proxyUrl);
                    if (url == null || "".equals(url)) {
                        url = p_url;
                    }
                    if (proxyUrl == null || "".equals(proxyUrl)) {
                        proxyUrl = p_proxyUrl;
                    }
                    routeModuleVo.setUrl(url);
                    routeModuleVo.setProxyUrl(proxyUrl);
                    routeModuleVo.setModuleName(key);
                    moduleMap.put(key, routeModuleVo);
                }
                routeVo.setModuleMap(moduleMap);
            }
            if ((apiList = root.selectNodes(xPath = "/" + this.Config + "/" + this.Route + "/" + this.api)).size() > 0) {
                HashMap<String, RouteApiVo> apiMap = new HashMap<String, RouteApiVo>();
                for (Element element22 : apiList) {
                    String key = element22.attributeValue(this.name);
                    String c_p_url = null;
                    String c_p_proxyUrl = null;
                    if (key == null || "".equals(key)) continue;
                    String apiKey = key;
                    RouteApiVo routeApiVo = new RouteApiVo();
                    url = element22.attributeValue(this.url);
                    proxyUrl = element22.attributeValue(this.proxyUrl);
                    if (url == null || "".equals(url)) {
                        url = p_url;
                    }
                    if (proxyUrl == null || "".equals(proxyUrl)) {
                        proxyUrl = p_proxyUrl;
                    }
                    c_p_url = url;
                    c_p_proxyUrl = proxyUrl;
                    routeApiVo.setApi(key);
                    routeApiVo.setUrl(url);
                    routeApiVo.setProxyUrl(proxyUrl);
                    List paramList = element22.selectNodes(this.param);
                    if (paramList.size() > 0) {
                        ArrayList<RouteParamVo> listParam = new ArrayList<RouteParamVo>();
                        for (Element element22 : paramList) {
                            String paramNameValue = element22.attributeValue(this.name);
                            String paramValueValue = element22.attributeValue(this.value);
                            if (paramNameValue == null || "".equals(paramNameValue) || paramValueValue == null || "".equals(paramValueValue)) continue;
                            RouteParamVo routeParamVo = new RouteParamVo();
                            url = element22.attributeValue(this.url);
                            proxyUrl = element22.attributeValue(this.proxyUrl);
                            if (url == null || "".equals(url)) {
                                url = c_p_url;
                            }
                            if (proxyUrl == null || "".equals(proxyUrl)) {
                                proxyUrl = c_p_proxyUrl;
                            }
                            String key1 = String.valueOf(key) + "_" + paramNameValue + "_" + paramValueValue;
                            routeParamVo.setUrl(url);
                            routeParamVo.setProxyUrl(proxyUrl);
                            routeParamVo.setParamName(paramNameValue);
                            routeParamVo.setParamValue(paramValueValue);
                            listParam.add(routeParamVo);
                        }
                        routeApiVo.setList(listParam);
                    }
                    apiMap.put(apiKey, routeApiVo);
                }
                routeVo.setApiMap(apiMap);
            }
            zkServiceMap.put(nodePath, serviceMap);
            zkRouteMap.put(nodePath, routeVo);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter w = new PrintWriter(sw);
            e.printStackTrace(w);
            Logger.get().error(this.getClass().getSimpleName(), new LogBody().set("\u65b9\u6cd5", Thread.currentThread().getStackTrace()[1].getMethodName()).set("\u5f02\u5e38", sw.toString()));
            throw e;
        }
    }

    private Url getUrl(String urlStr) throws Exception {
        if (urlStr == null || "".equals(urlStr)) {
            return null;
        }
        String prefix = "url\\.";
        String regex = "^" + prefix + ".*";
        boolean boo = urlStr.matches(regex);
        if (boo) {
            String tmp = ConfigReader.me((String)this.zkService).getNamePair(urlStr);
            String[] array = tmp.split(":");
            return new Url(array[0], Integer.parseInt(array[1]));
        }
        String[] tmp = urlStr.split(":");
        return new Url(tmp[0], Integer.parseInt(tmp[1]));
    }

    private String getProxyUrl(String proxyUrl) throws Exception {
        if (proxyUrl == null || "".equals(proxyUrl)) {
            return null;
        }
        String prefix = "url\\.";
        String regex = "^" + prefix + ".*";
        boolean boo = proxyUrl.matches(regex);
        if (boo) {
            return ConfigReader.me((String)this.zkService).getNamePair(proxyUrl);
        }
        return proxyUrl;
    }
}

