/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.wsgw.api;

import com.common.json.JSONObject;
import com.coreframework.log.LogBody;
import com.coreframework.log.Logger;
import com.coreframework.remoting.RemoteInvokeException;
import com.coreframework.remoting.Url;
import com.coreframework.remoting.reflect.InvokeRequest;
import com.coreframework.remoting.reflect.Rpc;
import com.coreframework.remoting.reflect.RpcException;
import com.coreframework.remoting.reflect.TimeOutException;
import com.yihu.monitor.sdk.NetworkUtil;
import com.yihu.wsgw.api.InterfaceMessage;
import com.yihu.wsgw.api.InvokeResult;
import com.yihu.wsgw.api.RouteParseUtil;
import com.yihu.wsgw.api.WeightedRoundRobinScheduling;
import com.yihu.wsgw.vo.MappingRouteVo;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ServiceBus {
    private static final AtomicLong REQUEST_ID = new AtomicLong(0L);
    private static ServiceBus instance;
    private static Object _lock;
    private String localIP;
    private String zkService;
    private String appId;
    private boolean debug;
    private static final ConcurrentHashMap<String, WeightedRoundRobinScheduling> roundmap;

    static {
        _lock = new Object();
        roundmap = new ConcurrentHashMap();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public ServiceBus(String zkService, String appId) {
        try {
            this.zkService = zkService;
            RouteParseUtil.getInstance(this.zkService);
            this.localIP = NetworkUtil.getLocalIP();
            this.appId = appId;
            if (this.localIP == null) {
                this.localIP = "0.0.0.0";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceBus getInstance(String zkService, String clientId) {
        if (instance == null) {
            Object object = _lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new ServiceBus(zkService, clientId);
                }
            }
        }
        return instance;
    }

    public InvokeResult call(String authInfoString, String api, String params, int paramType, int outType, String v, boolean hasLog, String sequenceNo) {
        long start = System.currentTimeMillis();
        if (authInfoString == null) {
            JSONObject authInfo = new JSONObject();
            try {
                authInfo.put("ClientId", this.appId);
                authInfo.put("ClientVersion", "1");
                authInfo.put("Sign", "");
                authInfo.put("SessionKey", "");
            }
            catch (Exception exception) {
                // empty catch block
            }
            authInfoString = authInfo.toString();
        }
        String result = null;
        Url url = null;
        String className = null;
        String methodName = null;
        InvokeResult r = new InvokeResult();
        if (api == null || api.split("\\.").length != 3) {
            result = this.getRetVal(outType, 20000, "api\u53c2\u6570\u7f3a\u5931\u6216api\u53c2\u6570\u503c\u683c\u5f0f\u9519\u8bef");
            r.setRet(result);
            return r;
        }
        MappingRouteVo vo = null;
        try {
            vo = RouteParseUtil.getInstance(this.zkService).queryMappingRouteVo(api, params);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            r.setRet(this.getRetVal(outType, 20001, String.valueOf(api) + ",\u8def\u7531\u89e3\u6790\u9519\u8bef," + e1.getMessage()));
            return r;
        }
        className = vo.getRemoteClass();
        String[] tmp = api.split("\\.");
        methodName = tmp[2];
        if (vo.getUrl() == null) {
            result = this.getRetVal(outType, 20002, "\u672a\u627e\u5230" + api + "\u53ef\u7528\u7684\u8def\u7531\u5730\u5740");
            r.setRet(result);
            return r;
        }
        url = null;
        int len = vo.getUrl().length;
        if (len == 0) {
            result = this.getRetVal(outType, 20002, "\u672a\u627e\u5230" + api + "\u53ef\u7528\u7684\u8def\u7531\u5730\u5740len == 0");
            r.setRet(result);
            return r;
        }
        if (len > 1) {
            try {
                String urls = vo.getUrls();
                WeightedRoundRobinScheduling wrs = roundmap.get(urls);
                if (wrs == null) {
                    wrs = new WeightedRoundRobinScheduling();
                    wrs.init(vo.getUrl());
                    roundmap.put(urls, wrs);
                }
                url = wrs.GetServer().getUrl();
            }
            catch (Exception e) {
                url = vo.getUrl()[0];
            }
        } else {
            url = vo.getUrl()[0];
        }
        if (className == null || className.equals("")) {
            result = this.getRetVal(outType, -14444, String.valueOf(api) + ",className\u4e0d\u80fd\u4e3a\u7a7a");
            r.setRet(result);
            return r;
        }
        if (url == null) {
            result = this.getRetVal(outType, -14444, String.valueOf(api) + ",url\u4e0d\u80fd\u4e3a\u7a7a");
            r.setRet(result);
            return r;
        }
        r.setUrl(url);
        r.setClassName(className);
        r.setMethodName(methodName);
        InvokeRequest req = new InvokeRequest(url, className, methodName, String.class);
        InterfaceMessage message = new InterfaceMessage();
        message.setApiName(api);
        message.setAuthInfo(authInfoString);
        message.setOutType(outType);
        message.setParam(params);
        message.setParamType(paramType);
        message.setSeq(sequenceNo == null ? Long.toString(start) : sequenceNo);
        req.add(InterfaceMessage.class, message);
        req.setSendTimeOutMills(30000);
        String uniqueReqId = String.valueOf(REQUEST_ID.getAndIncrement()) + UUID.randomUUID().toString();
        req.setRpcReqId(uniqueReqId);
        req.setConnectTimeOutMills(5000);
        req.setSyncMode();
        try {
            result = (String)Rpc.invoke(req);
        }
        catch (Exception e) {
            if (e instanceof TimeOutException) {
                result = this.getRetVal(outType, 30000, e.getMessage());
                r.setUniqueReqId(uniqueReqId);
                r.setRet(result);
                return r;
            }
            if (e instanceof RemoteInvokeException && e.getCause() != null && e.getCause() instanceof NoSuchMethodException) {
                String msg = e.getClass() + ",url=" + url + " error:" + e.getCause().getMessage();
                result = this.getRetVal(outType, -14444, msg);
                r.setUniqueReqId(uniqueReqId);
                r.setRet(result);
                return r;
            }
            String msg = e.getClass() + ",url=" + url + " error:" + RpcException.getExceptionInfo(e);
            result = this.getRetVal(outType, 29999, msg);
            r.setUniqueReqId(uniqueReqId);
            r.setRet(result);
            return r;
        }
        if (result == null) {
            System.out.println("rpc,result is null:" + this.localIP + "->" + url);
            result = this.getRetVal(outType, 20004, "\u5e94\u7528\u7cfb\u7edf\u8fd4\u56de\u7a7a\u7ed3\u679c\u96c6");
            r.setRet(result);
            r.setUniqueReqId(uniqueReqId);
            return r;
        }
        if (hasLog) {
            if (this.isDebug()) {
                System.out.println(String.valueOf(api) + ":" + this.localIP + "->" + url + ",mills=" + (System.currentTimeMillis() - start));
            }
            try {
                Logger.get().info("wsgw-log", LogBody.me().set("AuthInfo", authInfoString).set("SequenceNo", Long.toString(start)).set("uniqueReqId", uniqueReqId).set("Api", api).set("Param", params).set("ParamType", paramType).set("OutType", outType).set("V", v).set("Result", result).set("Url", url == null ? "" : url.toString()).set("ClassName", className == null ? "" : className).set("MethodName", methodName == null ? "" : methodName).set("Times", System.currentTimeMillis() - start).set("ClientUrl", this.localIP).set("CurrTimes", System.currentTimeMillis()).set("WsgwUrl", ""));
            }
            catch (Exception e) {
                System.out.println("\u5199\u65e5\u5fd7\u5f02\u5e38");
            }
        }
        r.setRet(result);
        r.setUniqueReqId(uniqueReqId);
        return r;
    }

    public String call(String api, String params) {
        return this.call(null, api, params, 0, 0, "1", true, null).getRet();
    }

    public String call(String api, String params, int paramType, int outType) {
        return this.call(null, api, params, paramType, outType, "1", true, null).getRet();
    }

    public String call(String api, String params, int paramType, int outType, String v) {
        return this.call(null, api, params, paramType, outType, v, true, null).getRet();
    }

    public String call(String api, String params, boolean hasLog) {
        return this.call(null, api, params, 0, 0, "1", hasLog, null).getRet();
    }

    private String getRetVal(int outType, int code, String message) {
        if (outType == 0) {
            JSONObject json = new JSONObject();
            try {
                json.put("Code", code);
                json.put("Message", message);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return json.toString();
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><OutPut><Code>" + code + "</Code><Message>" + message + "</Message></OutPut>";
    }
}

