/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.wsgw.api;

import com.coreframework.remoting.MethodAccessManager;
import com.esotericsoftware.reflectasm.MethodAccess;
import com.yihu.wsgw.api.AsyncCallLog;
import com.yihu.wsgw.api.CallLog;
import com.yihu.wsgw.api.InterfaceMessage;
import com.yihu.wsgw.api.InvokeResult;
import com.yihu.wsgw.api.ReqInfo;
import com.yihu.wsgw.api.ServiceBus;
import com.yihu.wsgw.api.WsUtil;
import java.sql.Timestamp;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class TaskCallable
implements Callable<Integer> {
    private String localIP;
    private String zkService;
    private String appId;
    private static final ConcurrentHashMap<Class<?>, Object> map = new ConcurrentHashMap();
    private ReqInfo reqInfo;

    public TaskCallable(String zkService, String localIP, String appId, ReqInfo reqInfo) {
        this.zkService = zkService;
        this.localIP = localIP;
        this.appId = appId;
        this.reqInfo = reqInfo;
    }

    private String localExec(InterfaceMessage message, Class<?> c, String methodName) {
        try {
            Object obj = map.get(c);
            if (obj == null) {
                map.put(c, c.newInstance());
                obj = map.get(c);
            }
            MethodAccess ma = MethodAccessManager.getInstance().getMethodAccess(c);
            int index = ma.getIndex(methodName, InterfaceMessage.class);
            String ret = (String)ma.invoke(obj, index, message);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return WsUtil.getRetVal(message.getOutType(), 30000, e.getMessage());
        }
    }

    @Override
    public Integer call() throws Exception {
        block7: {
            String result = null;
            long start = System.currentTimeMillis();
            String acceptorId = null;
            String acceptorIp = null;
            try {
                try {
                    InterfaceMessage message = new InterfaceMessage();
                    message.setAuthInfo(this.reqInfo.getAuthInfo());
                    message.setApiName(this.reqInfo.getApi());
                    message.setOutType(this.reqInfo.getOutType());
                    message.setParamType(this.reqInfo.getParamType());
                    message.setVersion(this.reqInfo.getV());
                    message.setParam(this.reqInfo.getParam());
                    message.setSeq(this.reqInfo.getSequenceNo());
                    if (this.reqInfo.getC() != null && this.reqInfo.getMethodName() != null) {
                        result = this.localExec(message, this.reqInfo.getC(), this.reqInfo.getMethodName());
                        acceptorId = this.appId;
                        acceptorIp = this.localIP;
                    } else {
                        InvokeResult invokeResult = ServiceBus.getInstance(this.zkService, this.appId).call(null, this.reqInfo.getApi(), this.reqInfo.getParam(), this.reqInfo.getParamType(), this.reqInfo.getOutType(), "1", true, this.reqInfo.getSequenceNo());
                        acceptorId = this.reqInfo.getApi().split("\\.")[0];
                        acceptorIp = invokeResult.getUrl().getIp();
                        result = invokeResult.getRet();
                    }
                }
                catch (Exception e) {
                    System.out.println("\u5f02\u6b65\u4efb\u52a1\u5931\u8d25," + e.getMessage());
                    result = WsUtil.getRetVal(this.reqInfo.getOutType(), -14444, e.getMessage());
                    CallLog callLog = new CallLog(this.reqInfo);
                    callLog.setAcceptorId(acceptorId);
                    callLog.setAcceptorIp(acceptorIp);
                    callLog.setAcceptorTime(new Timestamp(start).toString());
                    callLog.setResult(result);
                    callLog.setMills(System.currentTimeMillis() - start);
                    AsyncCallLog.sendLog(this.zkService, callLog);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                CallLog callLog = new CallLog(this.reqInfo);
                callLog.setAcceptorId(acceptorId);
                callLog.setAcceptorIp(acceptorIp);
                callLog.setAcceptorTime(new Timestamp(start).toString());
                callLog.setResult(result);
                callLog.setMills(System.currentTimeMillis() - start);
                AsyncCallLog.sendLog(this.zkService, callLog);
                throw throwable;
            }
            CallLog callLog = new CallLog(this.reqInfo);
            callLog.setAcceptorId(acceptorId);
            callLog.setAcceptorIp(acceptorIp);
            callLog.setAcceptorTime(new Timestamp(start).toString());
            callLog.setResult(result);
            callLog.setMills(System.currentTimeMillis() - start);
            AsyncCallLog.sendLog(this.zkService, callLog);
        }
        return 1;
    }
}

