/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.wsgw.api;

import com.coreframework.log.LogBody;
import com.coreframework.log.Logger;
import com.yihu.wsgw.api.ReqInfo;
import com.yihu.wsgw.api.TaskGroupLockManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class TaskHsqlDb {
    private static TaskHsqlDb instance;
    private Connection c;
    private static Object _lock;

    static {
        _lock = new Object();
    }

    public static void main(String[] args) {
        TaskHsqlDb.get().query(1);
        TaskHsqlDb.get().delete(15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskHsqlDb get() {
        if (instance == null) {
            Object object = _lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new TaskHsqlDb();
                }
            }
        }
        return instance;
    }

    private TaskHsqlDb() {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            this.c = DriverManager.getConnection("jdbc:h2:./LocalDB", "sa", "");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean existTable(String tableName) {
        Statement statement;
        Connection c;
        block5: {
            try {
                try {
                    Class.forName("org.h2.Driver");
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                c = DriverManager.getConnection("jdbc:h2:./LocalDB", "sa", "");
                statement = c.createStatement();
                ResultSet rs = statement.executeQuery("SELECT count(1) FROM " + tableName);
                if (!rs.next()) break block5;
                return true;
            }
            catch (SQLException e) {
                return false;
            }
        }
        statement.close();
        c.close();
        return false;
    }

    public List<ReqInfo> query(int groupID) {
        ArrayList<ReqInfo> list;
        block13: {
            PreparedStatement statement = null;
            list = new ArrayList<ReqInfo>();
            try {
                try {
                    statement = this.c.prepareStatement("SELECT top 10 * FROM TaskTable where groupID=?  order by id");
                    statement.setInt(1, groupID);
                    ResultSet rs = statement.executeQuery();
                    while (rs.next()) {
                        ReqInfo current = new ReqInfo();
                        current.setId(rs.getInt("id"));
                        current.setApi(rs.getString("api"));
                        current.setAuthInfo(rs.getString("authInfo"));
                        current.setC(rs.getString("className") == null || rs.getString("className").equals("") ? null : Class.forName(rs.getString("className")));
                        current.setClientIp(rs.getString("clientIp"));
                        current.setMethodName(rs.getString("methodName"));
                        current.setOutType(rs.getInt("outType"));
                        current.setParam(rs.getString("param"));
                        current.setParamType(rs.getInt("paramType"));
                        current.setSendTime(rs.getString("sendTime"));
                        current.setSequenceNo(rs.getString("sequenceNo"));
                        current.setV(rs.getString("v"));
                        current.setGroupID(rs.getInt("groupID"));
                        list.add(current);
                        current = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (statement == null) break block13;
                    try {
                        statement.close();
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int insertTaskTable(ReqInfo info) throws SQLException {
        int n;
        block19: {
            PreparedStatement statement = null;
            try {
                int k;
                statement = this.c.prepareStatement("insert into TaskTable(sequenceNo,authInfo,api,param,paramType,outType,clientIp,v,sendTime,className,methodName,groupID )  values(?,?,?,?,?,?,?,?,?,?,?,?)");
                statement.setObject(1, info.getSequenceNo());
                statement.setObject(2, info.getAuthInfo());
                statement.setObject(3, info.getApi());
                statement.setObject(4, info.getParam());
                statement.setObject(5, info.getParamType());
                statement.setObject(6, info.getOutType());
                statement.setObject(7, info.getClientIp());
                statement.setObject(8, info.getV());
                statement.setObject(9, info.getSendTime());
                statement.setObject(10, info.getC() == null ? "" : info.getC().getName());
                statement.setObject(11, info.getMethodName() == null ? "" : info.getMethodName());
                statement.setObject(12, info.getGroupID());
                n = k = statement.executeUpdate();
                if (statement == null) break block19;
            }
            catch (SQLException e) {
                try {
                    Logger.get().error("h2-log", LogBody.me().set("req", info.toString()).set(e));
                    throw e;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                        }
                    }
                    try {
                        Object obj;
                        Object object = obj = TaskGroupLockManager.getInstance().getLockObject(info.getGroupID());
                        synchronized (object) {
                            obj.notify();
                            throw throwable;
                        }
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                        System.out.println("\u91ca\u653e" + info.getGroupID() + "\u4efb\u52a1\u5206\u7ec4\u5bf9\u5e94\u7684\u5bf9\u8c61\u9501\u5f02\u5e38\uff1a" + e3.getMessage());
                    }
                    throw throwable;
                }
            }
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        try {
            Object obj;
            Object object = obj = TaskGroupLockManager.getInstance().getLockObject(info.getGroupID());
            synchronized (object) {
                obj.notify();
                return n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u91ca\u653e" + info.getGroupID() + "\u4efb\u52a1\u5206\u7ec4\u5bf9\u5e94\u7684\u5bf9\u8c61\u9501\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return n;
    }

    public int delete(int id) {
        PreparedStatement statement = null;
        try {
            int k;
            statement = this.c.prepareStatement("delete from TaskTable where id=?");
            statement.setObject(1, id);
            int n = k = statement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
            Logger.get().error("h2-log", LogBody.me().set("reqid", id).set(e));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return 0;
    }

    public void initTaskTable() {
        try {
            if (this.existTable("TaskTable")) {
                return;
            }
            try {
                Class.forName("org.h2.Driver");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            Connection c = DriverManager.getConnection("jdbc:h2:./LocalDB", "sa", "");
            Statement statement = c.createStatement();
            statement.executeUpdate("create  table TaskTable(id int auto_increment primary key,sequenceNo varchar(50),authInfo varchar(200),api varchar(100),param varchar(3000),paramType int,outType int,clientIp varchar(50),v varchar(50),sendTime datetime,className varchar(200),methodName varchar(100),groupID int)");
            statement.close();
            c.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            Logger.get().error("h2-log", LogBody.me().set(e));
        }
    }
}

