/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.wsgw.api;

import com.coreframework.remoting.Url;
import com.yihu.wsgw.api.ServerMachine;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class WeightedRoundRobinScheduling {
    private int currentIndex = -1;
    private int currentWeight = 0;
    private int maxWeight = 0;
    private int gcdWeight = 0;
    private int serverCount = 0;
    private List<ServerMachine> serverList;

    private static int gcd(int a, int b) {
        BigInteger b1 = new BigInteger(String.valueOf(a));
        BigInteger b2 = new BigInteger(String.valueOf(b));
        BigInteger gcd = b1.gcd(b2);
        return gcd.intValue();
    }

    private static int getGCDForServers(List<ServerMachine> serverList) {
        int w = 0;
        int i = 0;
        int len = serverList.size();
        while (i < len - 1) {
            w = w == 0 ? WeightedRoundRobinScheduling.gcd(serverList.get((int)i).weight, serverList.get((int)(i + 1)).weight) : WeightedRoundRobinScheduling.gcd(w, serverList.get((int)(i + 1)).weight);
            ++i;
        }
        return w;
    }

    public static int getMaxWeightForServers(List<ServerMachine> serverList) {
        int w = 0;
        int i = 0;
        int len = serverList.size();
        while (i < len - 1) {
            w = w == 0 ? Math.max(serverList.get((int)i).weight, serverList.get((int)(i + 1)).weight) : Math.max(w, serverList.get((int)(i + 1)).weight);
            ++i;
        }
        return w;
    }

    public ServerMachine GetServer() {
        do {
            this.currentIndex = (this.currentIndex + 1) % this.serverCount;
            if (this.currentIndex != 0) continue;
            this.currentWeight -= this.gcdWeight;
            if (this.currentWeight > 0) continue;
            this.currentWeight = this.maxWeight;
            if (this.currentWeight != 0) continue;
            return null;
        } while (this.serverList.get((int)this.currentIndex).weight < this.currentWeight);
        return this.serverList.get(this.currentIndex);
    }

    public void init(Url[] urls) {
        this.serverList = new ArrayList<ServerMachine>();
        int weight = 10 / urls.length;
        int i = 0;
        while (i < urls.length) {
            ServerMachine s1 = new ServerMachine(urls[i], weight);
            this.serverList.add(s1);
            ++i;
        }
        this.currentIndex = -1;
        this.currentWeight = 0;
        this.serverCount = this.serverList.size();
        this.maxWeight = WeightedRoundRobinScheduling.getMaxWeightForServers(this.serverList);
        this.gcdWeight = WeightedRoundRobinScheduling.getGCDForServers(this.serverList);
    }
}

