/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.wsgw.api;

import com.yihu.wsgw.api.UTF8PostMethod;
import com.yihu.wsgw.api.WsUtil;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class WsClient {
    private int connectionTimeout = 8000;
    private int soTimeOut = 8000;
    private HttpClient httpClient = new HttpClient();
    private String url;
    private String clientId;
    private String clientVersion;
    private static WsClient client;
    private static Object _lock;

    static {
        _lock = new Object();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public WsClient() {
        this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(this.connectionTimeout);
        this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(this.soTimeOut);
        this.clientId = "DEFAULT-Client";
        this.clientVersion = "1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WsClient getWsClient(String clientId, String url) {
        if (client == null) {
            Object object = _lock;
            synchronized (object) {
                if (client == null) {
                    client = new WsClient();
                }
            }
        }
        client.setUrl(url);
        client.setClientId(clientId == null ? "DEFAULT-Client" : clientId);
        return client;
    }

    public String call(String api, String params, int paramType, int outType, String v) {
        JSONObject json = new JSONObject();
        json.put((Object)"ClientId", (Object)this.clientId);
        json.put((Object)"ClientVersion", (Object)this.clientVersion);
        json.put((Object)"Sign", (Object)"");
        json.put((Object)"SessionKey", (Object)"");
        UTF8PostMethod postMethod = new UTF8PostMethod(this.url);
        postMethod.addParameter("AuthInfo", json.toString());
        postMethod.addParameter("SequenceNo", Long.toString(System.currentTimeMillis()));
        postMethod.addParameter("Api", api);
        postMethod.addParameter("Param", params);
        postMethod.addParameter("ParamType", Integer.toString(paramType));
        postMethod.addParameter("OutType", Integer.toString(outType));
        postMethod.addParameter("V", v);
        return this.doPost(outType, postMethod);
    }

    public String call(String api, String params) {
        return this.call(api, params, 0, 0, "1");
    }

    public String call(String api, String params, String v) {
        return this.call(api, params, 0, 0, v);
    }

    private String doPost(int outType, PostMethod postMethod) {
        try {
            this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(this.connectionTimeout);
            this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(this.soTimeOut);
            int statusCode = this.httpClient.executeMethod((HttpMethod)postMethod);
            if (statusCode == 200) {
                String string = postMethod.getResponseBodyAsString();
                return string;
            }
            String string = WsUtil.getRetVal(outType, -14444, "\ufffd\ufffd\ufffd\u04fd\u04ff\ufffd\ufffd\ufffd\ufffd\ufffd\ucce3,statusCode=" + statusCode);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = WsUtil.getRetVal(outType, -14444, "\ufffd\ufffd\ufffd\u04fd\u04ff\ufffd\ufffd\ufffd\ufffd\ufffd\ucce3," + e.getMessage());
            return string;
        }
        finally {
            postMethod.releaseConnection();
            this.httpClient.getHttpConnectionManager().closeIdleConnections(0L);
        }
    }
}

