/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.wsgw.mq;

import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;

public class JmsSender {
    private static Object _lock = new Object();
    private String USER = ActiveMQConnection.DEFAULT_USER;
    private String PASSWORD = ActiveMQConnection.DEFAULT_PASSWORD;
    private String brokerUrl;
    private Connection conn = null;
    private Session session = null;
    private static final ConcurrentHashMap<String, JmsSender> senderMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, MessageProducer> producerMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JmsSender get(String brokerUrl) throws JMSException, Exception {
        JmsSender sender = senderMap.get(brokerUrl);
        if (sender == null) {
            Object object = _lock;
            synchronized (object) {
                if (sender == null) {
                    sender = new JmsSender(brokerUrl);
                    senderMap.put(brokerUrl, sender);
                }
            }
        }
        return sender;
    }

    private JmsSender(String brokerUrl) throws JMSException, Exception {
        this.brokerUrl = brokerUrl;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.USER, this.PASSWORD, this.brokerUrl);
        this.conn = connectionFactory.createConnection();
        this.conn.start();
        this.session = this.conn.createSession(false, 1);
    }

    public void sendTextMessage(String subject, String textMsg) throws JMSException, Exception {
        MessageProducer producer = this.producerMap.get(subject);
        if (producer == null) {
            Queue destination = this.session.createQueue(subject);
            producer = this.session.createProducer((Destination)destination);
            producer.setDeliveryMode(1);
            this.producerMap.put(subject, producer);
        }
        TextMessage msg = this.session.createTextMessage();
        msg.setText(textMsg);
        producer.send((Message)msg);
    }
}

