/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.session;

import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionAttributeMap;
import org.apache.mina.core.session.IoSessionDataStructureFactory;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestQueue;

public class DefaultIoSessionDataStructureFactory
implements IoSessionDataStructureFactory {
    @Override
    public IoSessionAttributeMap getAttributeMap(IoSession session) throws Exception {
        return new DefaultIoSessionAttributeMap();
    }

    @Override
    public WriteRequestQueue getWriteRequestQueue(IoSession session) throws Exception {
        return new DefaultWriteRequestQueue();
    }

    private static class DefaultIoSessionAttributeMap
    implements IoSessionAttributeMap {
        private final Map<Object, Object> attributes = new ConcurrentHashMap<Object, Object>(4);

        @Override
        public Object getAttribute(IoSession session, Object key, Object defaultValue) {
            if (key == null) {
                throw new IllegalArgumentException("key");
            }
            Object answer = this.attributes.get(key);
            if (answer == null) {
                return defaultValue;
            }
            return answer;
        }

        @Override
        public Object setAttribute(IoSession session, Object key, Object value) {
            if (key == null) {
                throw new IllegalArgumentException("key");
            }
            if (value == null) {
                return this.attributes.remove(key);
            }
            return this.attributes.put(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object setAttributeIfAbsent(IoSession session, Object key, Object value) {
            Object oldValue;
            if (key == null) {
                throw new IllegalArgumentException("key");
            }
            if (value == null) {
                return null;
            }
            Map<Object, Object> map = this.attributes;
            synchronized (map) {
                oldValue = this.attributes.get(key);
                if (oldValue == null) {
                    this.attributes.put(key, value);
                }
            }
            return oldValue;
        }

        @Override
        public Object removeAttribute(IoSession session, Object key) {
            if (key == null) {
                throw new IllegalArgumentException("key");
            }
            return this.attributes.remove(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAttribute(IoSession session, Object key, Object value) {
            if (key == null) {
                throw new IllegalArgumentException("key");
            }
            if (value == null) {
                return false;
            }
            Map<Object, Object> map = this.attributes;
            synchronized (map) {
                block6: {
                    if (!value.equals(this.attributes.get(key))) break block6;
                    this.attributes.remove(key);
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean replaceAttribute(IoSession session, Object key, Object oldValue, Object newValue) {
            Map<Object, Object> map = this.attributes;
            synchronized (map) {
                block6: {
                    Object actualOldValue;
                    block5: {
                        actualOldValue = this.attributes.get(key);
                        if (actualOldValue != null) break block5;
                        return false;
                    }
                    if (!actualOldValue.equals(oldValue)) break block6;
                    this.attributes.put(key, newValue);
                    return true;
                }
                return false;
            }
        }

        @Override
        public boolean containsAttribute(IoSession session, Object key) {
            return this.attributes.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Object> getAttributeKeys(IoSession session) {
            Map<Object, Object> map = this.attributes;
            synchronized (map) {
                return new HashSet<Object>(this.attributes.keySet());
            }
        }

        @Override
        public void dispose(IoSession session) throws Exception {
        }
    }

    private static class DefaultWriteRequestQueue
    implements WriteRequestQueue {
        private final Queue<WriteRequest> q = new ConcurrentLinkedQueue<WriteRequest>();

        @Override
        public void dispose(IoSession session) {
        }

        @Override
        public void clear(IoSession session) {
            this.q.clear();
        }

        @Override
        public synchronized boolean isEmpty(IoSession session) {
            return this.q.isEmpty();
        }

        @Override
        public synchronized void offer(IoSession session, WriteRequest writeRequest) {
            this.q.offer(writeRequest);
        }

        @Override
        public synchronized WriteRequest poll(IoSession session) {
            return this.q.poll();
        }

        public String toString() {
            return this.q.toString();
        }
    }
}

