/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import java.net.SocketAddress;
import java.util.Queue;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.DefaultWriteFuture;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.DefaultWriteRequest;
import org.apache.mina.core.write.NothingWrittenException;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestWrapper;
import org.apache.mina.filter.codec.AbstractProtocolDecoderOutput;
import org.apache.mina.filter.codec.AbstractProtocolEncoderOutput;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderException;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.RecoverableProtocolDecoderException;
import rpc.org.slf4j.Logger;
import rpc.org.slf4j.LoggerFactory;

public class ProtocolCodecFilter
extends IoFilterAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolCodecFilter.class);
    private static final Class<?>[] EMPTY_PARAMS = new Class[0];
    private static final IoBuffer EMPTY_BUFFER = IoBuffer.wrap(new byte[0]);
    private final AttributeKey ENCODER = new AttributeKey(ProtocolCodecFilter.class, "encoder");
    private final AttributeKey DECODER = new AttributeKey(ProtocolCodecFilter.class, "decoder");
    private final AttributeKey DECODER_OUT = new AttributeKey(ProtocolCodecFilter.class, "decoderOut");
    private final AttributeKey ENCODER_OUT = new AttributeKey(ProtocolCodecFilter.class, "encoderOut");
    private final ProtocolCodecFactory factory;

    public ProtocolCodecFilter(ProtocolCodecFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory");
        }
        this.factory = factory;
    }

    public ProtocolCodecFilter(final ProtocolEncoder encoder, final ProtocolDecoder decoder) {
        if (encoder == null) {
            throw new IllegalArgumentException("encoder");
        }
        if (decoder == null) {
            throw new IllegalArgumentException("decoder");
        }
        this.factory = new ProtocolCodecFactory(){

            @Override
            public ProtocolEncoder getEncoder(IoSession session) {
                return encoder;
            }

            @Override
            public ProtocolDecoder getDecoder(IoSession session) {
                return decoder;
            }
        };
    }

    public ProtocolCodecFilter(Class<? extends ProtocolEncoder> encoderClass, Class<? extends ProtocolDecoder> decoderClass) {
        ProtocolDecoder decoder;
        ProtocolEncoder encoder;
        if (encoderClass == null) {
            throw new IllegalArgumentException("encoderClass");
        }
        if (decoderClass == null) {
            throw new IllegalArgumentException("decoderClass");
        }
        if (!ProtocolEncoder.class.isAssignableFrom(encoderClass)) {
            throw new IllegalArgumentException("encoderClass: " + encoderClass.getName());
        }
        if (!ProtocolDecoder.class.isAssignableFrom(decoderClass)) {
            throw new IllegalArgumentException("decoderClass: " + decoderClass.getName());
        }
        try {
            encoderClass.getConstructor(EMPTY_PARAMS);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("encoderClass doesn't have a public default constructor.");
        }
        try {
            decoderClass.getConstructor(EMPTY_PARAMS);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("decoderClass doesn't have a public default constructor.");
        }
        try {
            encoder = encoderClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("encoderClass cannot be initialized");
        }
        try {
            decoder = decoderClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("decoderClass cannot be initialized");
        }
        this.factory = new ProtocolCodecFactory(){

            @Override
            public ProtocolEncoder getEncoder(IoSession session) throws Exception {
                return encoder;
            }

            @Override
            public ProtocolDecoder getDecoder(IoSession session) throws Exception {
                return decoder;
            }
        };
    }

    public ProtocolEncoder getEncoder(IoSession session) {
        return (ProtocolEncoder)session.getAttribute(this.ENCODER);
    }

    @Override
    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (parent.contains(this)) {
            throw new IllegalArgumentException("You can't add the same filter instance more than once.  Create another instance and add it.");
        }
    }

    @Override
    public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        this.disposeCodec(parent.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        LOGGER.debug("Processing a MESSAGE_RECEIVED for session {}", session.getId());
        if (!(message instanceof IoBuffer)) {
            nextFilter.messageReceived(session, message);
            return;
        }
        IoBuffer in = (IoBuffer)message;
        ProtocolDecoder decoder = this.factory.getDecoder(session);
        ProtocolDecoderOutput decoderOut = this.getDecoderOut(session, nextFilter);
        while (in.hasRemaining()) {
            int oldPos = in.position();
            try {
                ProtocolDecoderOutput protocolDecoderOutput = decoderOut;
                synchronized (protocolDecoderOutput) {
                    decoder.decode(session, in, decoderOut);
                }
                decoderOut.flush(nextFilter, session);
            }
            catch (Throwable t) {
                ProtocolDecoderException pde = t instanceof ProtocolDecoderException ? (ProtocolDecoderException)t : new ProtocolDecoderException(t);
                if (pde.getHexdump() == null) {
                    int curPos = in.position();
                    in.position(oldPos);
                    pde.setHexdump(in.getHexDump());
                    in.position(curPos);
                }
                decoderOut.flush(nextFilter, session);
                nextFilter.exceptionCaught(session, pde);
                if (!(t instanceof RecoverableProtocolDecoderException) || in.position() == oldPos) break;
            }
        }
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        if (writeRequest instanceof EncodedWriteRequest) {
            return;
        }
        if (writeRequest instanceof MessageWriteRequest) {
            MessageWriteRequest wrappedRequest = (MessageWriteRequest)writeRequest;
            nextFilter.messageSent(session, wrappedRequest.getParentRequest());
        } else {
            nextFilter.messageSent(session, writeRequest);
        }
    }

    @Override
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        Object message = writeRequest.getMessage();
        if (message instanceof IoBuffer || message instanceof FileRegion) {
            nextFilter.filterWrite(session, writeRequest);
            return;
        }
        ProtocolEncoder encoder = this.factory.getEncoder(session);
        ProtocolEncoderOutput encoderOut = this.getEncoderOut(session, nextFilter, writeRequest);
        if (encoder == null) {
            throw new ProtocolEncoderException("The encoder is null for the session " + session);
        }
        if (encoderOut == null) {
            throw new ProtocolEncoderException("The encoderOut is null for the session " + session);
        }
        try {
            encoder.encode(session, message, encoderOut);
            Queue<Object> bufferQueue = ((AbstractProtocolEncoderOutput)encoderOut).getMessageQueue();
            while (!bufferQueue.isEmpty()) {
                Object encodedMessage = bufferQueue.poll();
                if (encodedMessage == null) break;
                if (encodedMessage instanceof IoBuffer && !((IoBuffer)encodedMessage).hasRemaining()) continue;
                SocketAddress destination = writeRequest.getDestination();
                EncodedWriteRequest encodedWriteRequest = new EncodedWriteRequest(encodedMessage, null, destination);
                nextFilter.filterWrite(session, encodedWriteRequest);
            }
            nextFilter.filterWrite(session, new MessageWriteRequest(writeRequest));
        }
        catch (Throwable t) {
            ProtocolEncoderException pee = t instanceof ProtocolEncoderException ? (ProtocolEncoderException)t : new ProtocolEncoderException(t);
            throw pee;
        }
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        ProtocolDecoder decoder = this.factory.getDecoder(session);
        ProtocolDecoderOutput decoderOut = this.getDecoderOut(session, nextFilter);
        try {
            try {
                decoder.finishDecode(session, decoderOut);
            }
            catch (Throwable t) {
                ProtocolDecoderException pde = t instanceof ProtocolDecoderException ? (ProtocolDecoderException)t : new ProtocolDecoderException(t);
                throw pde;
            }
        }
        finally {
            this.disposeCodec(session);
            decoderOut.flush(nextFilter, session);
        }
        nextFilter.sessionClosed(session);
    }

    private void disposeCodec(IoSession session) {
        this.disposeEncoder(session);
        this.disposeDecoder(session);
        this.disposeDecoderOut(session);
    }

    private void disposeEncoder(IoSession session) {
        ProtocolEncoder encoder = (ProtocolEncoder)session.removeAttribute(this.ENCODER);
        if (encoder == null) {
            return;
        }
        try {
            encoder.dispose(session);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to dispose: " + encoder.getClass().getName() + " (" + encoder + ')');
        }
    }

    private void disposeDecoder(IoSession session) {
        ProtocolDecoder decoder = (ProtocolDecoder)session.removeAttribute(this.DECODER);
        if (decoder == null) {
            return;
        }
        try {
            decoder.dispose(session);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to dispose: " + decoder.getClass().getName() + " (" + decoder + ')');
        }
    }

    private ProtocolDecoderOutput getDecoderOut(IoSession session, IoFilter.NextFilter nextFilter) {
        ProtocolDecoderOutput out = (ProtocolDecoderOutput)session.getAttribute(this.DECODER_OUT);
        if (out == null) {
            out = new ProtocolDecoderOutputImpl();
            session.setAttribute(this.DECODER_OUT, out);
        }
        return out;
    }

    private ProtocolEncoderOutput getEncoderOut(IoSession session, IoFilter.NextFilter nextFilter, WriteRequest writeRequest) {
        ProtocolEncoderOutput out = (ProtocolEncoderOutput)session.getAttribute(this.ENCODER_OUT);
        if (out == null) {
            out = new ProtocolEncoderOutputImpl(session, nextFilter, writeRequest);
            session.setAttribute(this.ENCODER_OUT, out);
        }
        return out;
    }

    private void disposeDecoderOut(IoSession session) {
        session.removeAttribute(this.DECODER_OUT);
    }

    private static class EncodedWriteRequest
    extends DefaultWriteRequest {
        public EncodedWriteRequest(Object encodedMessage, WriteFuture future, SocketAddress destination) {
            super(encodedMessage, future, destination);
        }

        @Override
        public boolean isEncoded() {
            return true;
        }
    }

    private static class MessageWriteRequest
    extends WriteRequestWrapper {
        public MessageWriteRequest(WriteRequest writeRequest) {
            super(writeRequest);
        }

        @Override
        public Object getMessage() {
            return EMPTY_BUFFER;
        }

        @Override
        public String toString() {
            return "MessageWriteRequest, parent : " + super.toString();
        }
    }

    private static class ProtocolDecoderOutputImpl
    extends AbstractProtocolDecoderOutput {
        @Override
        public void flush(IoFilter.NextFilter nextFilter, IoSession session) {
            Queue<Object> messageQueue = this.getMessageQueue();
            while (!messageQueue.isEmpty()) {
                nextFilter.messageReceived(session, messageQueue.poll());
            }
        }
    }

    private static class ProtocolEncoderOutputImpl
    extends AbstractProtocolEncoderOutput {
        private final IoSession session;
        private final IoFilter.NextFilter nextFilter;
        private final WriteRequest writeRequest;

        public ProtocolEncoderOutputImpl(IoSession session, IoFilter.NextFilter nextFilter, WriteRequest writeRequest) {
            this.session = session;
            this.nextFilter = nextFilter;
            this.writeRequest = writeRequest;
        }

        @Override
        public WriteFuture flush() {
            Queue<Object> bufferQueue = this.getMessageQueue();
            WriteFuture future = null;
            while (!bufferQueue.isEmpty()) {
                Object encodedMessage = bufferQueue.poll();
                if (encodedMessage == null) break;
                if (encodedMessage instanceof IoBuffer && !((IoBuffer)encodedMessage).hasRemaining()) continue;
                future = new DefaultWriteFuture(this.session);
                this.nextFilter.filterWrite(this.session, new EncodedWriteRequest(encodedMessage, future, this.writeRequest.getDestination()));
            }
            if (future == null) {
                future = DefaultWriteFuture.newNotWrittenFuture(this.session, new NothingWrittenException(this.writeRequest));
            }
            return future;
        }
    }
}

