/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.executor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.session.IoEvent;
import org.apache.mina.filter.executor.IoEventQueueHandler;

public class UnorderedThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Runnable EXIT_SIGNAL = new Runnable(){

        @Override
        public void run() {
            throw new Error("This method shouldn't be called. Please file a bug report.");
        }
    };
    private final Set<Worker> workers = new HashSet<Worker>();
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private volatile int largestPoolSize;
    private final AtomicInteger idleWorkers = new AtomicInteger();
    private long completedTaskCount;
    private volatile boolean shutdown;
    private final IoEventQueueHandler queueHandler;

    public UnorderedThreadPoolExecutor() {
        this(16);
    }

    public UnorderedThreadPoolExecutor(int maximumPoolSize) {
        this(0, maximumPoolSize);
    }

    public UnorderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize) {
        this(corePoolSize, maximumPoolSize, 30L, TimeUnit.SECONDS);
    }

    public UnorderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, Executors.defaultThreadFactory());
    }

    public UnorderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, IoEventQueueHandler queueHandler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, Executors.defaultThreadFactory(), queueHandler);
    }

    public UnorderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, threadFactory, null);
    }

    public UnorderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory, IoEventQueueHandler queueHandler) {
        super(0, 1, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
        if (corePoolSize < 0) {
            throw new IllegalArgumentException("corePoolSize: " + corePoolSize);
        }
        if (maximumPoolSize == 0 || maximumPoolSize < corePoolSize) {
            throw new IllegalArgumentException("maximumPoolSize: " + maximumPoolSize);
        }
        if (queueHandler == null) {
            queueHandler = IoEventQueueHandler.NOOP;
        }
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.queueHandler = queueHandler;
    }

    public IoEventQueueHandler getQueueHandler() {
        return this.queueHandler;
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWorker() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            if (this.workers.size() >= this.maximumPoolSize) {
                return;
            }
            Worker worker = new Worker();
            Thread thread = this.getThreadFactory().newThread(worker);
            this.idleWorkers.incrementAndGet();
            thread.start();
            this.workers.add(worker);
            if (this.workers.size() > this.largestPoolSize) {
                this.largestPoolSize = this.workers.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWorkerIfNecessary() {
        if (this.idleWorkers.get() == 0) {
            Set<Worker> set = this.workers;
            synchronized (set) {
                if (this.workers.isEmpty() || this.idleWorkers.get() == 0) {
                    this.addWorker();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWorker() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            if (this.workers.size() <= this.corePoolSize) {
                return;
            }
            this.getQueue().offer(EXIT_SIGNAL);
        }
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0 || maximumPoolSize < this.corePoolSize) {
            throw new IllegalArgumentException("maximumPoolSize: " + maximumPoolSize);
        }
        Set<Worker> set = this.workers;
        synchronized (set) {
            this.maximumPoolSize = maximumPoolSize;
            int difference = this.workers.size() - maximumPoolSize;
            while (difference > 0) {
                this.removeWorker();
                --difference;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        Set<Worker> set = this.workers;
        synchronized (set) {
            while (!this.isTerminated()) {
                long waitTime = deadline - System.currentTimeMillis();
                if (waitTime <= 0L) break;
                this.workers.wait(waitTime);
            }
        }
        return this.isTerminated();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        if (!this.shutdown) {
            return false;
        }
        Set<Worker> set = this.workers;
        synchronized (set) {
            return this.workers.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Set<Worker> set = this.workers;
        synchronized (set) {
            int i = this.workers.size();
            while (i > 0) {
                this.getQueue().offer(EXIT_SIGNAL);
                --i;
            }
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        Runnable task;
        this.shutdown();
        ArrayList<Runnable> answer = new ArrayList<Runnable>();
        while ((task = (Runnable)this.getQueue().poll()) != null) {
            if (task == EXIT_SIGNAL) {
                this.getQueue().offer(EXIT_SIGNAL);
                Thread.yield();
                continue;
            }
            this.getQueueHandler().polled(this, (IoEvent)task);
            answer.add(task);
        }
        return answer;
    }

    @Override
    public void execute(Runnable task) {
        if (this.shutdown) {
            this.rejectTask(task);
        }
        this.checkTaskType(task);
        IoEvent e = (IoEvent)task;
        boolean offeredEvent = this.queueHandler.accept(this, e);
        if (offeredEvent) {
            this.getQueue().offer(e);
        }
        this.addWorkerIfNecessary();
        if (offeredEvent) {
            this.queueHandler.offered(this, e);
        }
    }

    private void rejectTask(Runnable task) {
        this.getRejectedExecutionHandler().rejectedExecution(task, this);
    }

    private void checkTaskType(Runnable task) {
        if (!(task instanceof IoEvent)) {
            throw new IllegalArgumentException("task must be an IoEvent or its subclass.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveCount() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            return this.workers.size() - this.idleWorkers.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCompletedTaskCount() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            long answer = this.completedTaskCount;
            for (Worker w : this.workers) {
                answer += w.completedTaskCount;
            }
            return answer;
        }
    }

    @Override
    public int getLargestPoolSize() {
        return this.largestPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPoolSize() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            return this.workers.size();
        }
    }

    @Override
    public long getTaskCount() {
        return this.getCompletedTaskCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminating() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            return this.isShutdown() && !this.isTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prestartAllCoreThreads() {
        int answer = 0;
        Set<Worker> set = this.workers;
        synchronized (set) {
            int i = this.corePoolSize - this.workers.size();
            while (i > 0) {
                this.addWorker();
                ++answer;
                --i;
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prestartCoreThread() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            block4: {
                if (this.workers.size() >= this.corePoolSize) break block4;
                this.addWorker();
                return true;
            }
            return false;
        }
    }

    @Override
    public void purge() {
    }

    @Override
    public boolean remove(Runnable task) {
        boolean removed = super.remove(task);
        if (removed) {
            this.getQueueHandler().polled(this, (IoEvent)task);
        }
        return removed;
    }

    @Override
    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCorePoolSize(int corePoolSize) {
        if (corePoolSize < 0) {
            throw new IllegalArgumentException("corePoolSize: " + corePoolSize);
        }
        if (corePoolSize > this.maximumPoolSize) {
            throw new IllegalArgumentException("corePoolSize exceeds maximumPoolSize");
        }
        Set<Worker> set = this.workers;
        synchronized (set) {
            if (this.corePoolSize > corePoolSize) {
                int i = this.corePoolSize - corePoolSize;
                while (i > 0) {
                    this.removeWorker();
                    --i;
                }
            }
            this.corePoolSize = corePoolSize;
        }
    }

    static /* synthetic */ Set access$0(UnorderedThreadPoolExecutor unorderedThreadPoolExecutor) {
        return unorderedThreadPoolExecutor.workers;
    }

    static /* synthetic */ long access$1(UnorderedThreadPoolExecutor unorderedThreadPoolExecutor) {
        return unorderedThreadPoolExecutor.completedTaskCount;
    }

    static /* synthetic */ void access$2(UnorderedThreadPoolExecutor unorderedThreadPoolExecutor, long l) {
        unorderedThreadPoolExecutor.completedTaskCount = l;
    }

    static /* synthetic */ AtomicInteger access$3(UnorderedThreadPoolExecutor unorderedThreadPoolExecutor) {
        return unorderedThreadPoolExecutor.idleWorkers;
    }

    static /* synthetic */ int access$4(UnorderedThreadPoolExecutor unorderedThreadPoolExecutor) {
        return unorderedThreadPoolExecutor.corePoolSize;
    }

    static /* synthetic */ Runnable access$5() {
        return EXIT_SIGNAL;
    }

    static /* synthetic */ IoEventQueueHandler access$6(UnorderedThreadPoolExecutor unorderedThreadPoolExecutor) {
        return unorderedThreadPoolExecutor.queueHandler;
    }

    private class Worker
    implements Runnable {
        private volatile long completedTaskCount;
        private Thread thread;

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block17: {
                this.thread = Thread.currentThread();
                try {
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        task = this.fetchTask();
                        UnorderedThreadPoolExecutor.access$3(UnorderedThreadPoolExecutor.this).decrementAndGet();
                        if (task == null) {
                            var2_2 = UnorderedThreadPoolExecutor.access$0(UnorderedThreadPoolExecutor.this);
                            synchronized (var2_2) {
                                if (UnorderedThreadPoolExecutor.access$0(UnorderedThreadPoolExecutor.this).size() > UnorderedThreadPoolExecutor.access$4(UnorderedThreadPoolExecutor.this)) {
                                    UnorderedThreadPoolExecutor.access$0(UnorderedThreadPoolExecutor.this).remove(this);
                                    break block17;
                                }
                            }
                        }
                        if (task == UnorderedThreadPoolExecutor.access$5()) break block17;
                        try {
                            if (task == null) ** GOTO lbl-1000
                            UnorderedThreadPoolExecutor.access$6(UnorderedThreadPoolExecutor.this).polled(UnorderedThreadPoolExecutor.this, (IoEvent)task);
                            this.runTask(task);
                        }
                        finally {
                            UnorderedThreadPoolExecutor.access$3(UnorderedThreadPoolExecutor.this).incrementAndGet();
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable var3_4) {
                    var4_5 = UnorderedThreadPoolExecutor.access$0(UnorderedThreadPoolExecutor.this);
                    synchronized (var4_5) {
                        UnorderedThreadPoolExecutor.access$0(UnorderedThreadPoolExecutor.this).remove(this);
                        v1 = UnorderedThreadPoolExecutor.this;
                        UnorderedThreadPoolExecutor.access$2(v1, UnorderedThreadPoolExecutor.access$1(v1) + this.completedTaskCount);
                        UnorderedThreadPoolExecutor.access$0(UnorderedThreadPoolExecutor.this).notifyAll();
                    }
                    throw var3_4;
                }
                ** GOTO lbl-1000
            }
            var4_6 = UnorderedThreadPoolExecutor.access$0(UnorderedThreadPoolExecutor.this);
            synchronized (var4_6) {
                UnorderedThreadPoolExecutor.access$0(UnorderedThreadPoolExecutor.this).remove(this);
                v3 = UnorderedThreadPoolExecutor.this;
                UnorderedThreadPoolExecutor.access$2(v3, UnorderedThreadPoolExecutor.access$1(v3) + this.completedTaskCount);
                UnorderedThreadPoolExecutor.access$0(UnorderedThreadPoolExecutor.this).notifyAll();
            }
        }

        private Runnable fetchTask() {
            Runnable task = null;
            long currentTime = System.currentTimeMillis();
            long deadline = currentTime + UnorderedThreadPoolExecutor.this.getKeepAliveTime(TimeUnit.MILLISECONDS);
            while (true) {
                try {
                    long waitTime = deadline - currentTime;
                    if (waitTime <= 0L) break;
                    try {
                        task = UnorderedThreadPoolExecutor.this.getQueue().poll(waitTime, TimeUnit.MILLISECONDS);
                    }
                    finally {
                        if (task == null) {
                            currentTime = System.currentTimeMillis();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            return task;
        }

        private void runTask(Runnable task) {
            UnorderedThreadPoolExecutor.this.beforeExecute(this.thread, task);
            boolean ran = false;
            try {
                task.run();
                ran = true;
                UnorderedThreadPoolExecutor.this.afterExecute(task, null);
                ++this.completedTaskCount;
            }
            catch (RuntimeException e) {
                if (!ran) {
                    UnorderedThreadPoolExecutor.this.afterExecute(task, e);
                }
                throw e;
            }
        }
    }
}

